/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.providers.elasticache;

import com.google.code.ssm.providers.CacheClient;
import com.google.code.ssm.providers.CacheClientFactory;
import com.google.code.ssm.providers.CacheConfiguration;
import com.google.code.ssm.providers.elasticache.ElastiCacheConfiguration;
import com.google.code.ssm.providers.elasticache.MemcacheClientWrapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcacheClientFactoryImpl
implements CacheClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemcacheClientFactoryImpl.class);
    private ConnectionFactory connectionFactory;

    public CacheClient create(List<InetSocketAddress> addrs, CacheConfiguration conf) throws IOException {
        if (this.connectionFactory == null) {
            ElastiCacheConfiguration elasticacheConf = null;
            if (conf instanceof ElastiCacheConfiguration) {
                elasticacheConf = (ElastiCacheConfiguration)conf;
            }
            if (elasticacheConf != null && Boolean.TRUE.equals(elasticacheConf.getUseAutoDiscovery())) {
                LOGGER.info("All cache settings will be ignored because useAutoDiscovery is true");
                return new MemcacheClientWrapper((MemcachedClientIF)new MemcachedClient(addrs));
            }
            ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder();
            if (conf.isConsistentHashing()) {
                builder.setHashAlg((HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH);
                builder.setLocatorType(ConnectionFactoryBuilder.Locator.CONSISTENT);
            }
            builder.setProtocol(conf.isUseBinaryProtocol() ? ConnectionFactoryBuilder.Protocol.BINARY : ConnectionFactoryBuilder.Protocol.TEXT);
            if (conf.getOperationTimeout() != null) {
                builder.setOpTimeout((long)conf.getOperationTimeout().intValue());
            }
            if (elasticacheConf != null) {
                this.setProviderSpecificSettings(builder, elasticacheConf);
            }
            this.connectionFactory = builder.build();
        }
        return new MemcacheClientWrapper((MemcachedClientIF)new MemcachedClient(this.connectionFactory, addrs));
    }

    private void setProviderSpecificSettings(ConnectionFactoryBuilder builder, ElastiCacheConfiguration conf) {
        if (conf.getDaemon() != null) {
            builder.setDaemon(conf.getDaemon().booleanValue());
        }
        if (conf.getFailureMode() != null) {
            builder.setFailureMode(conf.getFailureMode());
        }
        if (conf.getHashAlg() != null) {
            builder.setHashAlg(conf.getHashAlg());
        }
        if (conf.getLocatorType() != null) {
            builder.setLocatorType(conf.getLocatorType());
        }
        if (conf.getMaxReconnectDelay() != null) {
            builder.setMaxReconnectDelay(conf.getMaxReconnectDelay().longValue());
        }
        if (conf.getOpQueueMaxBlockTime() != null) {
            builder.setOpQueueMaxBlockTime(conf.getOpQueueMaxBlockTime().longValue());
        }
        if (conf.getOpTimeout() != null) {
            builder.setOpTimeout(conf.getOpTimeout().longValue());
        }
        if (conf.getReadBufferSize() != null) {
            builder.setReadBufferSize(conf.getReadBufferSize().intValue());
        }
        if (conf.getShouldOptimize() != null) {
            builder.setShouldOptimize(conf.getShouldOptimize().booleanValue());
        }
        if (conf.getTimeoutExceptionThreshold() != null) {
            builder.setTimeoutExceptionThreshold(conf.getTimeoutExceptionThreshold().intValue());
        }
        if (conf.getUseNagleAlgorithm() != null) {
            builder.setUseNagleAlgorithm(conf.getUseNagleAlgorithm().booleanValue());
        }
        if (conf.getDefaultTranscoder() != null) {
            builder.setTranscoder(conf.getDefaultTranscoder());
        }
        if (conf.getAuthDescriptor() != null) {
            builder.setAuthDescriptor(conf.getAuthDescriptor());
        }
        if (conf.getAuthWaitTime() != null) {
            builder.setAuthWaitTime(conf.getAuthWaitTime().longValue());
        }
        if (conf.getInitialObservers() != null) {
            builder.setInitialObservers(conf.getInitialObservers());
        }
        if (conf.getClientMode() != null) {
            builder.setClientMode(conf.getClientMode());
        }
        if (conf.getEnableMetricType() != null) {
            builder.setEnableMetrics(conf.getEnableMetricType());
        }
        if (conf.getMetricCollector() != null) {
            builder.setMetricCollector(conf.getMetricCollector());
        }
    }
}

