/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop;

import com.google.code.ssm.aop.MultiCacheAdvice;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.api.ReadThroughMultiCache;
import com.google.code.ssm.api.ReadThroughMultiCacheOption;
import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ReadThroughMultiCacheAdvice
extends MultiCacheAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(ReadThroughMultiCacheAdvice.class);

    @Pointcut(value="@annotation(com.google.code.ssm.api.ReadThroughMultiCache)")
    public void getMulti() {
    }

    @Around(value="getMulti()")
    public Object cacheMulti(ProceedingJoinPoint pjp) throws Throwable {
        MultiCacheAdvice.MultiCacheCoordinator coord;
        SerializationType serializationType;
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return pjp.proceed();
        }
        Object[] args = pjp.getArgs();
        try {
            Method methodToCache = this.getCacheBase().getMethodToCache((JoinPoint)pjp);
            this.getCacheBase().verifyReturnTypeIsList(methodToCache, ReadThroughMultiCache.class);
            ReadThroughMultiCache annotation = methodToCache.getAnnotation(ReadThroughMultiCache.class);
            serializationType = this.getCacheBase().getSerializationType(methodToCache);
            AnnotationData data = AnnotationDataBuilder.buildAnnotationData(annotation, ReadThroughMultiCache.class, methodToCache);
            this.verifyNoUseJsonAnnotation(methodToCache);
            coord = new MultiCacheAdvice.MultiCacheCoordinator(methodToCache, data);
            this.setMultiCacheOptions(coord, annotation.option());
            coord.setHolder(this.createObjectIdCacheKeyMapping(data, pjp.getArgs(), coord.getMethod()));
            List listKeyObjects = (List)Utils.getMethodArg(data.getListIndexInMethodArgs(), pjp.getArgs(), coord.getMethod().toString());
            coord.setListKeyObjects(listKeyObjects);
            coord.setInitialKey2Result(this.getCacheBase().getCache(data).getBulk(coord.getKey2Obj().keySet(), serializationType));
            if (coord.getMissedObjects().size() < 1) {
                return coord.generateResultList();
            }
            args = coord.modifyArgumentList(args);
        }
        catch (Throwable ex) {
            this.warn(ex, "Caching on %s aborted due to an error.", pjp.toShortString());
            return pjp.proceed();
        }
        List results = (List)pjp.proceed(args);
        try {
            if (results == null || results.isEmpty()) {
                if (coord.isAddNullsToCache()) {
                    this.addNullValues(coord.getMissedObjects(), coord, serializationType);
                }
                return coord.generatePartialResultList();
            }
            if (coord.isGenerateKeysFromResult()) {
                return this.generateByKeysFromResult(results, coord, serializationType);
            }
            return this.generateByKeysProviders(results, coord, serializationType);
        }
        catch (Throwable ex) {
            this.warn(ex, "Caching on %s aborted due to an error. The underlying method will be called twice.", pjp.toShortString());
            return pjp.proceed();
        }
    }

    private void setMultiCacheOptions(MultiCacheAdvice.MultiCacheCoordinator coord, ReadThroughMultiCacheOption options) {
        coord.setGenerateKeysFromResult(options.generateKeysFromResult());
        coord.setAddNullsToCache(options.addNullsToCache());
        coord.setSkipNullsInResult(options.skipNullsInResult());
    }

    private List<?> generateByKeysFromResult(List<Object> results, MultiCacheAdvice.MultiCacheCoordinator coord, SerializationType serializationType) throws Exception {
        if (results == null) {
            results = new ArrayList<Object>();
        } else if (!results.isEmpty()) {
            AnnotationData data = coord.getAnnotationData();
            for (Object resultObject : results) {
                String cacheKey = this.getCacheBase().getCacheKeyBuilder().getCacheKey(resultObject, data.getNamespace());
                this.getCacheBase().getCache(coord.getAnnotationData()).setSilently(cacheKey, data.getExpiration(), resultObject, serializationType);
                coord.getMissedObjects().remove(coord.getKey2Obj().get(cacheKey));
            }
        }
        if (coord.isAddNullsToCache()) {
            this.addNullValues(coord.getMissedObjects(), coord, serializationType);
        }
        results.addAll(coord.generatePartialResultList());
        return results;
    }

    private List<?> generateByKeysProviders(List<Object> results, MultiCacheAdvice.MultiCacheCoordinator coord, SerializationType serializationType) {
        if (results.size() != coord.getMissedObjects().size()) {
            this.getLogger().info("Did not receive a correlated amount of data from the target method.");
            results.addAll(coord.generatePartialResultList());
            return results;
        }
        Iterator<Object> misssedObjectsIter = coord.getMissedObjects().iterator();
        for (Object resultObject : results) {
            resultObject = this.getCacheBase().getSubmission(resultObject);
            Object keyObject = misssedObjectsIter.next();
            String cacheKey = coord.getObj2Key().get(keyObject);
            this.getCacheBase().getCache(coord.getAnnotationData()).setSilently(cacheKey, coord.getAnnotationData().getExpiration(), resultObject, serializationType);
            coord.getKey2Result().put(cacheKey, resultObject);
        }
        return coord.generateResultList();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

