/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.support;

import com.google.code.ssm.aop.support.CacheKeyMethodStore;
import com.google.code.ssm.aop.support.CacheKeyMethodStoreImpl;
import com.google.code.ssm.aop.support.KeyProvider;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;

public class DefaultKeyProvider
implements KeyProvider {
    private CacheKeyMethodStore methodStore = new CacheKeyMethodStoreImpl();

    public void setMethodStore(CacheKeyMethodStore methodStore) {
        this.methodStore = methodStore;
    }

    public CacheKeyMethodStore getMethodStore() {
        return this.methodStore;
    }

    @Override
    public String generateKey(Object keyObject) {
        if (keyObject == null) {
            throw new InvalidParameterException("keyObject must be defined");
        }
        try {
            Method keyMethod = this.getKeyMethod(keyObject);
            return this.generateObjectId(keyMethod, keyObject);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String[] generateKeys(Object[] keyObjects) {
        if (keyObjects == null || keyObjects.length < 1) {
            throw new InvalidParameterException("The key objects must be defined.");
        }
        String[] results = new String[keyObjects.length];
        for (int i = 0; i < keyObjects.length; ++i) {
            results[i] = this.generateKey(keyObjects[i]);
        }
        return results;
    }

    Method getKeyMethod(Object keyObject) throws NoSuchMethodException {
        return this.methodStore.getKeyMethod(keyObject.getClass());
    }

    String generateObjectId(Method keyMethod, Object keyObject) throws Exception {
        String objectId = (String)keyMethod.invoke(keyObject, (Object[])null);
        if (objectId == null || objectId.length() < 1) {
            throw new RuntimeException("Got an empty key value from " + keyMethod.getName());
        }
        return objectId;
    }
}

