/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.transcoders;

import com.google.code.ssm.json.Holder;
import com.google.code.ssm.providers.CacheTranscoder;
import com.google.code.ssm.providers.CachedObject;
import com.google.code.ssm.providers.CachedObjectImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JsonTranscoder
implements CacheTranscoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonTranscoder.class);
    private static final int JSON_SERIALIZED = 8;
    private final ObjectMapper mapper;

    public JsonTranscoder(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"'mapper' is required and cannot be null");
        this.mapper = mapper;
    }

    public boolean asyncDecode(CachedObject data) {
        return false;
    }

    @Override
    public Object decode(CachedObject data) {
        if ((data.getFlags() & 8) == 0) {
            LOGGER.warn("Cannot decode cached data {} using json transcoder", (Object)data);
            throw new RuntimeException("Cannot decode cached data using json transcoder");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data.getData());
        try {
            Object object = ((Holder)this.mapper.readValue((InputStream)bais, Holder.class)).getValue();
            return object;
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Error deserializing cached data %s", data.toString()), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error while closing stream", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CachedObject encode(Object o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.mapper.writeValue((OutputStream)baos, (Object)new Holder(o));
            CachedObjectImpl cachedObjectImpl = new CachedObjectImpl(8, baos.toByteArray());
            return cachedObjectImpl;
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Error serializing object %s", o), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error while closing stream", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public int getMaxSize() {
        return 0x100000;
    }

    public String toString() {
        return "JsonTranscoder(mapper=" + this.getMapper() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonTranscoder)) {
            return false;
        }
        JsonTranscoder other = (JsonTranscoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
    }

    public boolean canEqual(Object other) {
        return other instanceof JsonTranscoder;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        ObjectMapper $mapper = this.getMapper();
        result = result * 31 + ($mapper == null ? 0 : $mapper.hashCode());
        return result;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

