/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.util;

import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Iterator;

public class Utils {
    public static Object getMethodArg(int index, Object[] args, String methodDesc) {
        if (index < 0) {
            throw new InvalidParameterException(String.format("An index of %s is invalid", index));
        }
        if (args.length <= index) {
            throw new InvalidParameterException(String.format("An index of %s is too big for the number of arguments in [%s]", index, methodDesc));
        }
        Object indexObject = args[index];
        if (indexObject == null) {
            throw new InvalidParameterException(String.format("The argument passed into [%s] at index %s is null.", methodDesc, index));
        }
        return indexObject;
    }

    public static Object[] getMethodArgs(Collection<Integer> indexes, Object[] args, String methodDesc) {
        Object[] selectedArgs = new Object[indexes.size()];
        Iterator<Integer> iter = indexes.iterator();
        for (int i = 0; i < indexes.size(); ++i) {
            selectedArgs[i] = Utils.getMethodArg(iter.next(), args, methodDesc);
        }
        return selectedArgs;
    }

    public static Class<?>[] getMethodParameterTypes(Collection<Integer> indexes, Method method) {
        Class[] selectedParameterTypes = new Class[indexes.size()];
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        int i = 0;
        for (int index : indexes) {
            if (index < 0) {
                throw new InvalidParameterException(String.format("An index of %s is invalid", index));
            }
            if (methodParameterTypes.length <= index) {
                throw new InvalidParameterException(String.format("An index of %s is too big for the number of arguments in [%s]", index, method.toString()));
            }
            selectedParameterTypes[i++] = methodParameterTypes[index];
        }
        return selectedParameterTypes;
    }
}

