/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop;

import com.google.code.ssm.aop.CacheAdvice;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.api.InvalidateAssignCache;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class InvalidateAssignCacheAdvice
extends CacheAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidateAssignCacheAdvice.class);

    @Pointcut(value="@annotation(com.google.code.ssm.api.InvalidateAssignCache)")
    public void invalidateAssign() {
    }

    @Around(value="invalidateAssign()")
    public Object cacheInvalidateAssign(ProceedingJoinPoint pjp) throws Throwable {
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return pjp.proceed();
        }
        Object result = pjp.proceed();
        String cacheKey = null;
        try {
            Method methodToCache = this.getCacheBase().getMethodToCache((JoinPoint)pjp);
            InvalidateAssignCache annotation = methodToCache.getAnnotation(InvalidateAssignCache.class);
            AnnotationData data = AnnotationDataBuilder.buildAnnotationData(annotation, InvalidateAssignCache.class, methodToCache);
            cacheKey = this.getCacheBase().getCacheKeyBuilder().getAssignCacheKey(data);
            this.getCacheBase().getCache(data).delete(cacheKey);
        }
        catch (Throwable ex) {
            this.warn(ex, "Caching on method %s and key [%s] aborted due to an error.", pjp.toShortString(), cacheKey);
        }
        return result;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

