/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop;

import com.google.code.ssm.aop.CacheAdvice;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.PertinentNegativeNull;
import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

abstract class MultiCacheAdvice
extends CacheAdvice {
    MultiCacheAdvice() {
    }

    MapHolder createObjectIdCacheKeyMapping(AnnotationData data, Object[] args, Method methodToCache) throws Exception {
        MapHolder holder = new MapHolder();
        List<String> cacheKeys = this.getCacheBase().getCacheKeyBuilder().getCacheKeys(data, args, methodToCache.toString());
        List listObjects = (List)Utils.getMethodArg(data.getListIndexInMethodArgs(), args, methodToCache.toString());
        Iterator listObjectsIter = listObjects.iterator();
        Iterator<String> cacheKeysIter = cacheKeys.iterator();
        while (listObjectsIter.hasNext()) {
            Object obj = listObjectsIter.next();
            String cacheKey = cacheKeysIter.next();
            if (holder.getObj2Key().get(obj) == null) {
                holder.getObj2Key().put(obj, cacheKey);
            }
            if (holder.getKey2Obj().get(cacheKey) != null) continue;
            holder.getKey2Obj().put(cacheKey, obj);
        }
        return holder;
    }

    protected void addNullValues(List<Object> missObjects, MultiCacheCoordinator coord, SerializationType serializationType) {
        for (Object keyObject : missObjects) {
            this.getCacheBase().getCache(coord.getAnnotationData()).addSilently(coord.getObj2Key().get(keyObject), coord.getAnnotationData().getExpiration(), PertinentNegativeNull.NULL, serializationType);
        }
    }

    protected void setNullValues(List<Object> missObjects, MultiCacheCoordinator coord, SerializationType serializationType) {
        for (Object keyObject : missObjects) {
            this.getCacheBase().getCache(coord.getAnnotationData()).setSilently(coord.getObj2Key().get(keyObject), coord.getAnnotationData().getExpiration(), PertinentNegativeNull.NULL, serializationType);
        }
    }

    static class MultiCacheCoordinator {
        private final Method method;
        private final AnnotationData data;
        private final Map<String, Object> key2Obj = new LinkedHashMap<String, Object>();
        private final Map<Object, String> obj2Key = new LinkedHashMap<Object, String>();
        private final Map<String, Object> key2Result = new HashMap<String, Object>();
        private List<Object> listKeyObjects = new ArrayList<Object>();
        private final List<Object> missedObjects = new ArrayList<Object>();
        private boolean addNullsToCache;
        private boolean generateKeysFromResult;
        private boolean skipNullsInResult;

        MultiCacheCoordinator(Method method, AnnotationData data) {
            this.method = method;
            this.data = data;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean isAddNullsToCache() {
            return this.addNullsToCache;
        }

        public void setAddNullsToCache(boolean addNullsToCache) {
            this.addNullsToCache = addNullsToCache;
        }

        public void setGenerateKeysFromResult(boolean generateKeysFromResult) {
            this.generateKeysFromResult = generateKeysFromResult;
        }

        public boolean isGenerateKeysFromResult() {
            return this.generateKeysFromResult;
        }

        public AnnotationData getAnnotationData() {
            return this.data;
        }

        public void setHolder(MapHolder holder) {
            this.key2Obj.putAll(holder.getKey2Obj());
            this.obj2Key.putAll(holder.getObj2Key());
        }

        public Map<String, Object> getKey2Obj() {
            return this.key2Obj;
        }

        public Map<Object, String> getObj2Key() {
            return this.obj2Key;
        }

        public Map<String, Object> getKey2Result() {
            return this.key2Result;
        }

        public List<Object> getListKeyObjects() {
            return this.listKeyObjects;
        }

        public void setListKeyObjects(List<Object> listKeyObjects) {
            this.listKeyObjects = listKeyObjects;
        }

        public void setInitialKey2Result(Map<String, Object> key2Result) {
            if (key2Result == null) {
                throw new RuntimeException("There was an error retrieving cache values.");
            }
            this.key2Result.putAll(key2Result);
            LinkedHashSet<Object> missObjectSet = new LinkedHashSet<Object>();
            for (String key : this.key2Obj.keySet()) {
                if (this.key2Result.get(key) != null) continue;
                missObjectSet.add(this.key2Obj.get(key));
            }
            this.missedObjects.addAll(missObjectSet);
        }

        public List<Object> generateResultList() {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object keyObject : this.listKeyObjects) {
                String cacheKey = this.obj2Key.get(keyObject);
                Object keyResult = this.key2Result.get(cacheKey);
                if (keyResult == null) {
                    throw new RuntimeException(String.format("Unable to fulfill data for the key item [%s] with key value of [%s].", keyObject.toString(), this.obj2Key.get(keyObject)));
                }
                if (this.isSkipNullsInResult() && keyResult instanceof PertinentNegativeNull) continue;
                results.add(this.getResult(keyResult));
            }
            return results;
        }

        public List<Object> generatePartialResultList() {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object keyObject : this.listKeyObjects) {
                String cacheKey = this.obj2Key.get(keyObject);
                Object keyResult = this.key2Result.get(cacheKey);
                if (keyResult == null || this.isSkipNullsInResult() && keyResult instanceof PertinentNegativeNull) continue;
                results.add(this.getResult(keyResult));
            }
            return results;
        }

        public List<Object> getMissedObjects() {
            return this.missedObjects;
        }

        public Object[] modifyArgumentList(Object[] args) {
            args[this.data.getListIndexInMethodArgs()] = this.missedObjects;
            return args;
        }

        public void setSkipNullsInResult(boolean skipNullsInResult) {
            this.skipNullsInResult = skipNullsInResult;
        }

        public boolean isSkipNullsInResult() {
            return this.skipNullsInResult;
        }

        private Object getResult(Object result) {
            return result instanceof PertinentNegativeNull ? null : result;
        }
    }

    static class MapHolder {
        private final Map<String, Object> key2Obj = new LinkedHashMap<String, Object>();
        private final Map<Object, String> obj2Key = new LinkedHashMap<Object, String>();

        MapHolder() {
        }

        public Map<String, Object> getKey2Obj() {
            return this.key2Obj;
        }

        public Map<Object, String> getObj2Key() {
            return this.obj2Key;
        }
    }
}

