/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.config;

import com.google.code.ssm.config.DefaultAddressProvider;
import java.net.InetSocketAddress;
import java.util.List;
import javax.naming.NamingException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.util.Assert;

public class JndiAddressProvider
extends DefaultAddressProvider
implements InitializingBean {
    private final JndiTemplate jndiTemplate = new JndiTemplate();
    private String jndiKey;

    public JndiAddressProvider() {
    }

    public JndiAddressProvider(String jndiKey, String address) {
        super(address);
        this.jndiKey = jndiKey;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jndiKey, (String)"'jndiKey' is required and cannot be null");
    }

    @Override
    public List<InetSocketAddress> getAddresses() {
        Object ips = null;
        List<InetSocketAddress> addrs = null;
        try {
            if (this.jndiKey != null && (ips = this.lookup(this.jndiKey)) != null) {
                this.logger.info("Addresses from JNDI will be used to connect to memcached servers. Addresses: {}", ips);
                addrs = this.getAddresses((String)ips);
            } else {
                addrs = super.getAddresses();
            }
        }
        catch (NamingException ex) {
            this.logger.warn(String.format("Name of the JNDI key with memcached addresses is set but wrong value is bound to this key: %s", this.jndiKey), (Throwable)ex);
            addrs = super.getAddresses();
        }
        return addrs;
    }

    protected Object lookup(String key) throws NamingException {
        return this.jndiTemplate.lookup(key);
    }

    public String getJndiKey() {
        return this.jndiKey;
    }

    public void setJndiKey(String jndiKey) {
        this.jndiKey = jndiKey;
    }
}

