/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.transcoders;

import com.google.code.ssm.providers.CacheTranscoder;
import com.google.code.ssm.providers.CachedObject;
import com.google.code.ssm.providers.CachedObjectImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaTranscoder
implements CacheTranscoder {
    public static final int DEFAULT_COMPRESSION_THRESHOLD = 16384;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaTranscoder.class);
    private static final int SERIALIZED = 1;
    private static final int COMPRESSED = 2;
    private int compressionThreshold = 16384;

    @Override
    public Object decode(CachedObject d) {
        byte[] data = d.getData();
        if ((d.getFlags() & 2) != 0) {
            data = this.decompress(d.getData());
        }
        if ((d.getFlags() & 1) != 0 && data != null) {
            return this.deserialize(data);
        }
        LOGGER.warn("Cannot decode cached data {} using java transcoder", (Object)data);
        throw new RuntimeException("Cannot decode cached data using java transcoder");
    }

    @Override
    public CachedObject encode(Object o) {
        byte[] data = this.serialize(o);
        int flags = 1;
        if (data.length > this.getCompressionThreshold()) {
            byte[] compressed = this.compress(data);
            if (compressed.length < data.length) {
                LOGGER.debug("Compressed {} from {} to {}", new Object[]{o.getClass().getName(), data.length, compressed.length});
                data = compressed;
                flags |= 2;
            } else {
                LOGGER.info("Compression increased the size of {} from {} to {}", new Object[]{o.getClass().getName(), data.length, compressed.length});
            }
        }
        return new CachedObjectImpl(flags, data);
    }

    protected byte[] serialize(Object o) {
        if (o == null) {
            throw new NullPointerException("Can't serialize null");
        }
        byte[] data = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            os.writeObject(o);
            os.close();
            bos.close();
            data = bos.toByteArray();
            this.close(os);
            this.close(bos);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Non-serializable object", e);
            }
            catch (Throwable throwable) {
                this.close(os);
                this.close(bos);
                throw throwable;
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Object deserialize(byte[] in) {
        Object o = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream is = null;
        try {
            if (in != null) {
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                o = is.readObject();
                is.close();
                bis.close();
            }
            this.close(is);
            this.close(bis);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Caught IOException decoding %d bytes of data", in.length), (Throwable)e);
            this.close(is);
            this.close(bis);
        }
        catch (ClassNotFoundException e2) {
            LOGGER.warn(String.format("Caught CNFE decoding %d bytes of data", in.length), (Throwable)e2);
            this.close(is);
            this.close(bis);
            {
                catch (Throwable throwable) {
                    this.close(is);
                    this.close(bis);
                    throw throwable;
                }
            }
        }
        return o;
    }

    protected byte[] compress(byte[] in) {
        if (in == null) {
            throw new NullPointerException("Can't compress null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gz = null;
        try {
            gz = new GZIPOutputStream(bos);
            gz.write(in);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception compressing data", e);
        }
        finally {
            this.close(gz);
            this.close(bos);
        }
        return bos.toByteArray();
    }

    protected byte[] decompress(byte[] in) {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(in);
        GZIPInputStream gis = null;
        try {
            gis = new GZIPInputStream(bis);
            byte[] buf = new byte[8192];
            int r = -1;
            while ((r = gis.read(buf)) > 0) {
                bos.write(buf, 0, r);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception decompressing data", e);
        }
        finally {
            this.close(gis);
            this.close(bis);
            this.close(bos);
        }
    }

    protected void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOGGER.info(String.format("Unable to close %s", closeable), (Throwable)e);
            }
        }
    }

    public String toString() {
        return "JavaTranscoder(compressionThreshold=" + this.getCompressionThreshold() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaTranscoder)) {
            return false;
        }
        JavaTranscoder other = (JavaTranscoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getCompressionThreshold() == other.getCompressionThreshold();
    }

    public boolean canEqual(Object other) {
        return other instanceof JavaTranscoder;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.getCompressionThreshold();
        return result;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }
}

