/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop;

import com.google.code.ssm.aop.CacheAdvice;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.api.format.SerializationType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;

abstract class SingleReadCacheAdvice<T extends Annotation>
extends CacheAdvice {
    private final Class<T> annotationClass;

    protected SingleReadCacheAdvice(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    protected Object cache(ProceedingJoinPoint pjp) throws Throwable {
        AnnotationData data;
        SerializationType serializationType;
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return pjp.proceed();
        }
        String cacheKey = null;
        try {
            Method methodToCache = this.getCacheBase().getMethodToCache((JoinPoint)pjp);
            this.getCacheBase().verifyReturnTypeIsNoVoid(methodToCache, this.annotationClass);
            T annotation = methodToCache.getAnnotation(this.annotationClass);
            serializationType = this.getCacheBase().getSerializationType(methodToCache);
            data = AnnotationDataBuilder.buildAnnotationData(annotation, this.annotationClass, methodToCache);
            cacheKey = this.getCacheKey(data, pjp.getArgs(), methodToCache.toString());
            Object result = this.getCacheBase().getCache(data).get(cacheKey, serializationType);
            if (result != null) {
                this.getLogger().debug("Cache hit.");
                return this.getCacheBase().getResult(result);
            }
        }
        catch (Throwable ex) {
            this.warn(ex, "Caching on method %s and key [%s] aborted due to an error.", pjp.toShortString(), cacheKey);
            return pjp.proceed();
        }
        Object result = pjp.proceed();
        try {
            Object submission = this.getCacheBase().getSubmission(result);
            this.getCacheBase().getCache(data).set(cacheKey, data.getExpiration(), submission, serializationType);
        }
        catch (Throwable ex) {
            this.warn(ex, "Caching on method %s and key [%s] aborted due to an error.", pjp.toShortString(), cacheKey);
        }
        return result;
    }

    protected abstract String getCacheKey(AnnotationData var1, Object[] var2, String var3) throws Exception;
}

