/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.counter;

import com.google.code.ssm.aop.counter.CounterInCacheBase;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.api.counter.ReadCounterFromCache;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ReadCounterFromCacheAdvice
extends CounterInCacheBase {
    private static final Logger LOG = LoggerFactory.getLogger(ReadCounterFromCacheAdvice.class);

    @Pointcut(value="@annotation(com.google.code.ssm.api.counter.ReadCounterFromCache)")
    public void readSingleCounter() {
    }

    @Around(value="readSingleCounter()")
    public Object readCounter(ProceedingJoinPoint pjp) throws Throwable {
        AnnotationData data;
        ReadCounterFromCache annotation;
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return pjp.proceed();
        }
        String cacheKey = null;
        try {
            Method methodToCache = this.getCacheBase().getMethodToCache((JoinPoint)pjp);
            this.verifyMethodSignature(methodToCache);
            annotation = methodToCache.getAnnotation(ReadCounterFromCache.class);
            data = AnnotationDataBuilder.buildAnnotationData(annotation, ReadCounterFromCache.class, methodToCache);
            cacheKey = this.getCacheBase().getCacheKeyBuilder().getCacheKey(data, pjp.getArgs(), methodToCache.toString());
            Long result = this.getCacheBase().getCache(data).getCounter(cacheKey);
            if (result != null) {
                this.getLogger().debug("Cache hit.");
                return this.convertResult(methodToCache, result);
            }
        }
        catch (Throwable ex) {
            this.warn(ex, "Caching on method %s and key [%s] aborted due to an error.", pjp.toShortString(), cacheKey);
            return pjp.proceed();
        }
        Object result = pjp.proceed();
        try {
            if (this.checkData(result, (JoinPoint)pjp)) {
                long value = ((Number)result).longValue();
                this.getCacheBase().getCache(data).incr(cacheKey, 0, value, annotation.expiration());
            }
        }
        catch (Throwable ex) {
            this.warn(ex, "Caching on method %s and key [%s] aborted due to an error.", pjp.toShortString(), cacheKey);
        }
        return result;
    }

    protected void verifyMethodSignature(Method methodToCache) {
        if (!this.isReturnTypeSupported(methodToCache.getReturnType())) {
            throw new RuntimeException(String.format("Wrong method return type %s", methodToCache.toString()));
        }
    }

    protected Number convertResult(Method method, long result) {
        if (method.getReturnType().equals(Integer.TYPE) || method.getReturnType().equals(Integer.class)) {
            return (int)result;
        }
        return result;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

