/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.support;

import com.google.code.ssm.aop.support.CacheKeyMethodStore;
import com.google.code.ssm.aop.support.InvalidAnnotationException;
import com.google.code.ssm.api.CacheKeyMethod;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheKeyMethodStoreImpl
implements CacheKeyMethodStore {
    public static final String DEFAULT_KEY_METHOD_NAME = "toString";
    private final Map<Class<?>, Method> map = new ConcurrentHashMap();

    @Override
    public Method getKeyMethod(Class<?> keyClass) throws NoSuchMethodException {
        Method storedMethod = this.find(keyClass);
        if (storedMethod != null) {
            return storedMethod;
        }
        Method[] methods = keyClass.getDeclaredMethods();
        Method targetMethod = null;
        for (Method method : methods) {
            boolean isCacheKeyMethod = this.isCacheKeyMethod(method);
            if (isCacheKeyMethod && targetMethod != null) {
                throw new InvalidAnnotationException(String.format("Class [%s] should have only one method annotated with [%s]. See [%s] and [%s]", keyClass.getName(), CacheKeyMethod.class.getName(), targetMethod.getName(), method.getName()));
            }
            if (!isCacheKeyMethod) continue;
            targetMethod = method;
        }
        if (targetMethod == null) {
            Class<?> superKeyClass = keyClass.getSuperclass();
            if (superKeyClass != null) {
                targetMethod = this.getKeyMethod(superKeyClass);
            }
            if (targetMethod == null || DEFAULT_KEY_METHOD_NAME.equals(targetMethod.getName())) {
                targetMethod = keyClass.getMethod(DEFAULT_KEY_METHOD_NAME, null);
            }
        }
        this.add(keyClass, targetMethod);
        return targetMethod;
    }

    private boolean isCacheKeyMethod(Method method) {
        if (method != null && method.getAnnotation(CacheKeyMethod.class) != null) {
            if (method.getParameterTypes().length > 0) {
                throw new InvalidAnnotationException(String.format("Method [%s] must have 0 arguments to be annotated with [%s]", method.toString(), CacheKeyMethod.class.getName()));
            }
            if (!String.class.equals(method.getReturnType())) {
                throw new InvalidAnnotationException(String.format("Method [%s] must return a String to be annotated with [%s]", method.toString(), CacheKeyMethod.class.getName()));
            }
            return true;
        }
        return false;
    }

    private void add(Class<?> key, Method value) {
        this.map.put(key, value);
    }

    private Method find(Class<?> key) {
        return this.map.get(key);
    }
}

