/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.util.jndi;

import com.google.code.ssm.config.AddressChangeListener;
import com.google.code.ssm.config.AddressChangeNotifier;
import com.google.code.ssm.config.JndiAddressProvider;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class JndiChangeNotifier
extends JndiAddressProvider
implements AddressChangeNotifier,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JndiChangeNotifier.class);
    private AddressChangeListener addressChangeListener;
    private List<InetSocketAddress> currentAddrs;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.currentAddrs = this.getAddresses();
    }

    public void check() {
        List<InetSocketAddress> newAddrs = this.getAddresses();
        if (newAddrs != null && !((Object)newAddrs).equals(this.currentAddrs)) {
            if (this.addressChangeListener != null) {
                this.currentAddrs = newAddrs;
                this.addressChangeListener.changeAddresses(newAddrs);
            } else {
                LOGGER.error("Address change listener is null for JNDI key {}, cannot notify about new value {}", (Object)this.getJndiKey(), newAddrs);
            }
        }
    }

    public AddressChangeListener getAddressChangeListener() {
        return this.addressChangeListener;
    }

    @Override
    public void setAddressChangeListener(AddressChangeListener addressChangeListener) {
        this.addressChangeListener = addressChangeListener;
    }
}

