/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm;

import com.google.code.ssm.Cache;
import com.google.code.ssm.CacheImpl;
import com.google.code.ssm.CacheProperties;
import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.config.AddressChangeListener;
import com.google.code.ssm.config.AddressChangeNotifier;
import com.google.code.ssm.config.AddressProvider;
import com.google.code.ssm.mapper.JsonObjectMapper;
import com.google.code.ssm.providers.CacheClient;
import com.google.code.ssm.providers.CacheClientFactory;
import com.google.code.ssm.providers.CacheConfiguration;
import com.google.code.ssm.providers.CacheTranscoder;
import com.google.code.ssm.transcoders.JavaTranscoder;
import com.google.code.ssm.transcoders.JsonTranscoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CacheFactory
implements AddressChangeListener,
FactoryBean<Cache>,
InitializingBean,
DisposableBean {
    public static final String DISABLE_CACHE_PROPERTY = "ssm.cache.disable";
    public static final String DISABLE_CACHE_PROPERTY_VALUE = "true";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheFactory.class);
    private CacheConfiguration configuration = new CacheConfiguration();
    private AddressProvider addressProvider;
    private CacheClientFactory cacheClientFactory;
    private String cacheName = "default";
    private Collection<String> cacheAliases = Collections.emptyList();
    private CacheImpl cache;
    private AddressChangeNotifier addressChangeNotifier;
    private SerializationType defaultSerializationType = SerializationType.PROVIDER;
    private JsonTranscoder jsonTranscoder;
    private JavaTranscoder javaTranscoder;
    private CacheTranscoder customTranscoder;
    private boolean initializeTranscoders = true;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.configuration, (String)"'configuration' cannot be null");
        Assert.notNull((Object)this.addressProvider, (String)"'addressProvider' is required and cannot be null");
        Assert.notNull((Object)this.cacheClientFactory, (String)"'cacheClientFactory' is required and cannot be null");
        Assert.notNull((Object)this.cacheName, (String)"'cacheName' cannot be null");
        Assert.notNull((Object)((Object)this.defaultSerializationType), (String)"'defaultSerializationType' cannot be null");
        if (this.initializeTranscoders) {
            if (this.jsonTranscoder == null) {
                this.jsonTranscoder = new JsonTranscoder(new JsonObjectMapper());
            }
            if (this.javaTranscoder == null) {
                this.javaTranscoder = new JavaTranscoder();
            }
        }
        this.validateTranscoder(SerializationType.JSON, this.jsonTranscoder, "jsonTranscoder");
        this.validateTranscoder(SerializationType.JAVA, this.javaTranscoder, "javaTranscoder");
        this.validateTranscoder(SerializationType.CUSTOM, this.customTranscoder, "customTranscoder");
        if (this.addressChangeNotifier != null) {
            this.addressChangeNotifier.setAddressChangeListener(this);
        }
    }

    public Cache getObject() throws Exception {
        return this.createCache();
    }

    public Class<?> getObjectType() {
        return Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.cache != null) {
            LOGGER.info("Shutdowning cache {}", (Object)this.cacheName);
            this.cache.shutdown();
        }
    }

    @Override
    public void changeAddresses(List<InetSocketAddress> addresses) {
        block3: {
            if (this.isCacheDisabled()) {
                LOGGER.warn("Cache {} is disabled", (Object)this.cacheName);
                return;
            }
            try {
                LOGGER.info("Creating new memcached client for cache {} with new addresses: {}", (Object)this.cacheName, addresses);
                CacheClient memcacheClient = this.createClient(addresses);
                LOGGER.info("New memcached client for cache {} was created with addresses: {}", (Object)this.cacheName, addresses);
                this.cache.changeCacheClient(memcacheClient);
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error(String.format("Cannot change memcached client to new one with addresses %s", addresses), (Throwable)e);
            }
        }
    }

    protected Cache createCache() throws IOException {
        if (this.isCacheDisabled()) {
            LOGGER.warn("Cache {} is disabled", (Object)this.cacheName);
            return null;
        }
        if (this.cache != null) {
            throw new IllegalStateException(String.format("This factory has already created memcached client fro cache %s", this.cacheName));
        }
        if (this.configuration == null) {
            throw new RuntimeException(String.format("The MemcachedConnectionBean for cache %s must be defined!", this.cacheName));
        }
        List<InetSocketAddress> addrs = this.addressProvider.getAddresses();
        this.cache = new CacheImpl(this.cacheName, this.cacheAliases, this.createClient(addrs), this.defaultSerializationType, this.jsonTranscoder, this.javaTranscoder, this.customTranscoder, new CacheProperties(this.configuration.isUseNameAsKeyPrefix(), this.configuration.getKeyPrefixSeparator()));
        return this.cache;
    }

    private CacheClient createClient(List<InetSocketAddress> addrs) throws IOException {
        if (addrs == null || addrs.isEmpty()) {
            throw new IllegalArgumentException(String.format("No memcached addresses specified for cache %s", this.cacheName));
        }
        return this.cacheClientFactory.create(addrs, this.configuration);
    }

    private boolean isCacheDisabled() {
        return DISABLE_CACHE_PROPERTY_VALUE.equals(System.getProperty(DISABLE_CACHE_PROPERTY));
    }

    private void validateTranscoder(SerializationType serializationType, CacheTranscoder cacheTranscoder, String transcoderName) {
        if (this.defaultSerializationType == serializationType) {
            Assert.notNull((Object)cacheTranscoder, (String)String.format("'%s' cannot be null if default serialization type is set to %s", new Object[]{transcoderName, serializationType}));
        }
    }

    public CacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public AddressProvider getAddressProvider() {
        return this.addressProvider;
    }

    public CacheClientFactory getCacheClientFactory() {
        return this.cacheClientFactory;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Collection<String> getCacheAliases() {
        return this.cacheAliases;
    }

    public CacheImpl getCache() {
        return this.cache;
    }

    public AddressChangeNotifier getAddressChangeNotifier() {
        return this.addressChangeNotifier;
    }

    public SerializationType getDefaultSerializationType() {
        return this.defaultSerializationType;
    }

    public JsonTranscoder getJsonTranscoder() {
        return this.jsonTranscoder;
    }

    public JavaTranscoder getJavaTranscoder() {
        return this.javaTranscoder;
    }

    public CacheTranscoder getCustomTranscoder() {
        return this.customTranscoder;
    }

    public boolean isInitializeTranscoders() {
        return this.initializeTranscoders;
    }

    public void setConfiguration(CacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setAddressProvider(AddressProvider addressProvider) {
        this.addressProvider = addressProvider;
    }

    public void setCacheClientFactory(CacheClientFactory cacheClientFactory) {
        this.cacheClientFactory = cacheClientFactory;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setCacheAliases(Collection<String> cacheAliases) {
        this.cacheAliases = cacheAliases;
    }

    public void setAddressChangeNotifier(AddressChangeNotifier addressChangeNotifier) {
        this.addressChangeNotifier = addressChangeNotifier;
    }

    public void setDefaultSerializationType(SerializationType defaultSerializationType) {
        this.defaultSerializationType = defaultSerializationType;
    }

    public void setJsonTranscoder(JsonTranscoder jsonTranscoder) {
        this.jsonTranscoder = jsonTranscoder;
    }

    public void setJavaTranscoder(JavaTranscoder javaTranscoder) {
        this.javaTranscoder = javaTranscoder;
    }

    public void setCustomTranscoder(CacheTranscoder customTranscoder) {
        this.customTranscoder = customTranscoder;
    }

    public void setInitializeTranscoders(boolean initializeTranscoders) {
        this.initializeTranscoders = initializeTranscoders;
    }
}

