/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm;

import com.google.code.ssm.Cache;
import com.google.code.ssm.CacheProperties;
import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.providers.CacheClient;
import com.google.code.ssm.providers.CacheException;
import com.google.code.ssm.providers.CacheTranscoder;
import com.google.code.ssm.transcoders.JavaTranscoder;
import com.google.code.ssm.transcoders.JsonTranscoder;
import com.google.code.ssm.transcoders.LongToStringTranscoder;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class CacheImpl
implements Cache {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheImpl.class);
    private final String name;
    private final Collection<String> aliases;
    private final CacheProperties properties;
    private final SerializationType defaultSerializationType;
    private final JsonTranscoder jsonTranscoder;
    private final JavaTranscoder javaTranscoder;
    private final LongToStringTranscoder longToStringTranscoder = new LongToStringTranscoder();
    private final CacheTranscoder customTranscoder;
    private volatile CacheClient cacheClient;

    CacheImpl(String name, Collection<String> aliases, CacheClient cacheClient, SerializationType defaultSerializationType, JsonTranscoder jsonTranscoder, JavaTranscoder javaTranscoder, CacheTranscoder customTranscoder, CacheProperties properties) {
        Assert.hasText((String)name, (String)"'name' must not be null, empty, or blank");
        Assert.notNull(aliases, (String)"'aliases' cannot be null");
        Assert.notNull((Object)cacheClient, (String)"'cacheClient' cannot be null");
        Assert.notNull((Object)((Object)defaultSerializationType), (String)"'defaultSerializationType' cannot be null");
        Assert.notNull((Object)properties, (String)"'cacheProperties' cannot be null");
        this.validateTranscoder(SerializationType.JSON, jsonTranscoder, "jsonTranscoder");
        this.validateTranscoder(SerializationType.JAVA, javaTranscoder, "javaTranscoder");
        this.validateTranscoder(SerializationType.CUSTOM, customTranscoder, "customTranscoder");
        this.name = name;
        this.aliases = aliases;
        this.cacheClient = cacheClient;
        this.defaultSerializationType = defaultSerializationType;
        this.jsonTranscoder = jsonTranscoder;
        this.javaTranscoder = javaTranscoder;
        this.customTranscoder = customTranscoder;
        this.properties = properties;
    }

    @Override
    public Collection<SocketAddress> getAvailableServers() {
        return this.cacheClient.getAvailableServers();
    }

    @Override
    public <T> T get(String cacheKey, SerializationType serializationType) throws TimeoutException, CacheException {
        switch (this.getSerializationType(serializationType)) {
            case JAVA: {
                return this.get(cacheKey, SerializationType.JAVA, this.javaTranscoder);
            }
            case JSON: {
                return this.get(cacheKey, SerializationType.JSON, this.jsonTranscoder);
            }
            case PROVIDER: {
                return this.get(cacheKey, SerializationType.PROVIDER, null);
            }
            case CUSTOM: {
                return this.get(cacheKey, SerializationType.CUSTOM, this.customTranscoder);
            }
        }
        throw new IllegalArgumentException(String.format("Serialization type %s is not supported", new Object[]{serializationType}));
    }

    @Override
    public <T> void set(String cacheKey, int expiration, Object value, SerializationType serializationType) throws TimeoutException, CacheException {
        switch (this.getSerializationType(serializationType)) {
            case JAVA: {
                this.set(cacheKey, expiration, value, SerializationType.JAVA, this.javaTranscoder);
                break;
            }
            case JSON: {
                this.set(cacheKey, expiration, value, SerializationType.JSON, this.jsonTranscoder);
                break;
            }
            case PROVIDER: {
                this.set(cacheKey, expiration, value, SerializationType.PROVIDER, null);
                break;
            }
            case CUSTOM: {
                this.set(cacheKey, expiration, value, SerializationType.CUSTOM, this.customTranscoder);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Serialization type %s is not supported", new Object[]{serializationType}));
            }
        }
    }

    @Override
    public <T> void setSilently(String cacheKey, int expiration, Object value, SerializationType serializationType) {
        try {
            this.set(cacheKey, expiration, value, serializationType);
        }
        catch (TimeoutException e) {
            this.warn(e, "Cannot set on key %s", cacheKey);
        }
        catch (CacheException e) {
            this.warn(e, "Cannot set on key %s", cacheKey);
        }
    }

    @Override
    public <T> void add(String cacheKey, int expiration, Object value, SerializationType serializationType) throws TimeoutException, CacheException {
        switch (this.getSerializationType(serializationType)) {
            case JAVA: {
                this.add(cacheKey, expiration, value, SerializationType.JAVA, this.javaTranscoder);
                break;
            }
            case JSON: {
                this.add(cacheKey, expiration, value, SerializationType.JSON, this.jsonTranscoder);
                break;
            }
            case PROVIDER: {
                this.add(cacheKey, expiration, value, SerializationType.PROVIDER, null);
                break;
            }
            case CUSTOM: {
                this.add(cacheKey, expiration, value, SerializationType.CUSTOM, this.customTranscoder);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Serialization type %s is not supported", new Object[]{serializationType}));
            }
        }
    }

    @Override
    public <T> void addSilently(String cacheKey, int expiration, Object value, SerializationType serializationType) {
        try {
            this.add(cacheKey, expiration, value, serializationType);
        }
        catch (TimeoutException e) {
            this.warn(e, "Cannot add to key %s", cacheKey);
        }
        catch (CacheException e) {
            this.warn(e, "Cannot add to key %s", cacheKey);
        }
    }

    @Override
    public Map<String, Object> getBulk(Collection<String> keys, SerializationType serializationType) throws TimeoutException, CacheException {
        switch (this.getSerializationType(serializationType)) {
            case JAVA: {
                return this.getBulk(keys, SerializationType.JAVA, this.javaTranscoder);
            }
            case JSON: {
                return this.getBulk(keys, SerializationType.JSON, this.jsonTranscoder);
            }
            case PROVIDER: {
                return this.getBulk(keys, SerializationType.PROVIDER, null);
            }
            case CUSTOM: {
                return this.getBulk(keys, SerializationType.CUSTOM, this.customTranscoder);
            }
        }
        throw new IllegalArgumentException(String.format("Serialization type %s is not supported", new Object[]{serializationType}));
    }

    @Override
    public long decr(String key, int by) throws TimeoutException, CacheException {
        return this.cacheClient.decr(key, by);
    }

    @Override
    public boolean delete(String key) throws TimeoutException, CacheException {
        return this.cacheClient.delete(key);
    }

    @Override
    public void delete(Collection<String> keys) throws TimeoutException, CacheException {
        this.cacheClient.delete(keys);
    }

    @Override
    public void flush() throws TimeoutException, CacheException {
        this.cacheClient.flush();
    }

    @Override
    public long incr(String key, int by, long def) throws TimeoutException, CacheException {
        return this.cacheClient.incr(key, by, def);
    }

    @Override
    public long incr(String key, int by, long def, int exp) throws TimeoutException, CacheException {
        return this.cacheClient.incr(key, by, def, exp);
    }

    @Override
    public Long getCounter(String cacheKey) throws TimeoutException, CacheException {
        return (Long)this.cacheClient.get(cacheKey, this.longToStringTranscoder);
    }

    @Override
    public void setCounter(String cacheKey, int expiration, long value) throws TimeoutException, CacheException {
        this.cacheClient.set(cacheKey, expiration, value, this.longToStringTranscoder);
    }

    @Override
    public void shutdown() {
        this.cacheClient.shutdown();
    }

    void changeCacheClient(CacheClient newCacheClient) {
        if (newCacheClient != null) {
            LOGGER.info("Replacing the cache client");
            CacheClient oldCacheClient = this.cacheClient;
            this.cacheClient = newCacheClient;
            LOGGER.info("Cache client replaced");
            LOGGER.info("Closing old cache client");
            oldCacheClient.shutdown();
            LOGGER.info("Old cache client closed");
        }
    }

    private <T> T get(String cacheKey, SerializationType serializationType, CacheTranscoder cacheTranscoder) throws TimeoutException, CacheException {
        if (SerializationType.PROVIDER.equals((Object)serializationType)) {
            return (T)this.cacheClient.get(cacheKey);
        }
        if (cacheTranscoder == null) {
            throw new IllegalArgumentException(String.format("Cannot use %s serialization because dedicated cache transcoder is null!", new Object[]{serializationType}));
        }
        return this.cacheClient.get(cacheKey, cacheTranscoder);
    }

    private <T> void set(String cacheKey, int expiration, T value, SerializationType serializationType, CacheTranscoder cacheTranscoder) throws TimeoutException, CacheException {
        if (SerializationType.PROVIDER.equals((Object)serializationType)) {
            this.cacheClient.set(cacheKey, expiration, value);
            return;
        }
        if (cacheTranscoder == null) {
            throw new IllegalArgumentException(String.format("Cannot use %s serialization because dedicated cache transcoder is null!", new Object[]{serializationType}));
        }
        this.cacheClient.set(cacheKey, expiration, value, cacheTranscoder);
    }

    private <T> void add(String cacheKey, int expiration, Object value, SerializationType serializationType, CacheTranscoder cacheTranscoder) throws TimeoutException, CacheException {
        if (SerializationType.PROVIDER.equals((Object)serializationType)) {
            this.cacheClient.add(cacheKey, expiration, value);
            return;
        }
        if (cacheTranscoder == null) {
            throw new IllegalArgumentException(String.format("Cannot use %s serialization because dedicated cache transcoder is null!", new Object[]{serializationType}));
        }
        this.cacheClient.add(cacheKey, expiration, value, cacheTranscoder);
    }

    private Map<String, Object> getBulk(Collection<String> keys, SerializationType serializationType, CacheTranscoder cacheTranscoder) throws TimeoutException, CacheException {
        if (SerializationType.PROVIDER.equals((Object)serializationType)) {
            return this.cacheClient.getBulk(keys);
        }
        if (cacheTranscoder == null) {
            throw new IllegalArgumentException(String.format("Cannot use %s serialization because dedicated cache transcoder is null!", new Object[]{serializationType}));
        }
        return this.cacheClient.getBulk(keys, cacheTranscoder);
    }

    private SerializationType getSerializationType(SerializationType serializationType) {
        return serializationType != null ? serializationType : this.defaultSerializationType;
    }

    private void warn(Exception e, String format, Object ... args) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(String.format(format, args), (Throwable)e);
        }
    }

    private void validateTranscoder(SerializationType serializationType, CacheTranscoder cacheTranscoder, String transcoderName) {
        if (this.defaultSerializationType == serializationType) {
            Assert.notNull((Object)cacheTranscoder, (String)String.format("'%s' cannot be null if default serialization type is set to %s", new Object[]{transcoderName, serializationType}));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<String> getAliases() {
        return this.aliases;
    }

    @Override
    public CacheProperties getProperties() {
        return this.properties;
    }
}

