/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop;

import com.google.code.ssm.aop.CacheAdvice;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.api.format.SerializationType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;

abstract class SingleUpdateCacheAdvice<T extends Annotation>
extends CacheAdvice {
    private final Class<T> annotationClass;

    protected SingleUpdateCacheAdvice(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    protected void update(JoinPoint jp, Object retVal) throws Throwable {
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return;
        }
        String cacheKey = null;
        try {
            Method methodToCache = this.getCacheBase().getMethodToCache(jp);
            T annotation = methodToCache.getAnnotation(this.annotationClass);
            AnnotationData data = AnnotationDataBuilder.buildAnnotationData(annotation, this.annotationClass, methodToCache);
            cacheKey = data.isReturnKeyIndex() ? this.getCacheBase().getCacheKeyBuilder().getCacheKey(retVal, data.getNamespace()) : this.getCacheKey(data, jp.getArgs(), methodToCache.toString());
            Object dataObject = this.getCacheBase().getUpdateData(data, methodToCache, jp.getArgs(), retVal);
            SerializationType serializationType = this.getCacheBase().getSerializationType(methodToCache);
            Object submission = this.getCacheBase().getSubmission(dataObject);
            this.getCacheBase().getCache(data).set(cacheKey, data.getExpiration(), submission, serializationType);
        }
        catch (Exception ex) {
            this.warn(ex, "Caching on method %s and key [%s] aborted due to an error.", jp.toShortString(), cacheKey);
        }
    }

    protected abstract String getCacheKey(AnnotationData var1, Object[] var2, String var3) throws Exception;
}

