/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.counter;

import com.google.code.ssm.aop.counter.CounterInCacheBase;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.api.counter.DecrementCounterInCache;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class DecrementCounterInCacheAdvice
extends CounterInCacheBase {
    private static final Logger LOG = LoggerFactory.getLogger(DecrementCounterInCacheAdvice.class);

    @Pointcut(value="@annotation(com.google.code.ssm.api.counter.DecrementCounterInCache)")
    public void decrementSingleCounter() {
    }

    @AfterReturning(value="decrementSingleCounter()")
    public void decrementSingle(JoinPoint jp) throws Throwable {
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return;
        }
        String cacheKey = null;
        try {
            Method methodToCache = this.getCacheBase().getMethodToCache(jp);
            DecrementCounterInCache annotation = methodToCache.getAnnotation(DecrementCounterInCache.class);
            AnnotationData data = AnnotationDataBuilder.buildAnnotationData(annotation, DecrementCounterInCache.class, methodToCache);
            cacheKey = this.getCacheBase().getCacheKeyBuilder().getCacheKey(data, jp.getArgs(), methodToCache.toString());
            this.getCacheBase().getCache(data).decr(cacheKey, 1);
        }
        catch (Exception ex) {
            this.warn(ex, "Decrementing counter [%s] via %s aborted due to an error.", cacheKey, jp.toShortString());
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

