/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.counter;

import com.google.code.ssm.aop.counter.CounterInCacheBase;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.api.counter.IncrementCounterInCache;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class IncrementCounterInCacheAdvice
extends CounterInCacheBase {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementCounterInCacheAdvice.class);

    @Pointcut(value="@annotation(com.google.code.ssm.api.counter.IncrementCounterInCache)")
    public void incrementSingleCounter() {
    }

    @AfterReturning(value="incrementSingleCounter()")
    public void incrementSingle(JoinPoint jp) throws Throwable {
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return;
        }
        String cacheKey = null;
        try {
            Method methodToCache = this.getCacheBase().getMethodToCache(jp);
            IncrementCounterInCache annotation = methodToCache.getAnnotation(IncrementCounterInCache.class);
            AnnotationData data = AnnotationDataBuilder.buildAnnotationData(annotation, IncrementCounterInCache.class, methodToCache);
            cacheKey = this.getCacheBase().getCacheKeyBuilder().getCacheKey(data, jp.getArgs(), methodToCache.toString());
            this.getCacheBase().getCache(data).incr(cacheKey, 1, 1L);
        }
        catch (Exception ex) {
            this.warn(ex, "Incrementing counter [%s] via %s aborted due to an error.", cacheKey, jp.toShortString());
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

