/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.support;

import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.InvalidAnnotationException;
import com.google.code.ssm.api.CacheName;
import com.google.code.ssm.api.InvalidateAssignCache;
import com.google.code.ssm.api.InvalidateMultiCache;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterDataUpdateContent;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughMultiCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import com.google.code.ssm.api.ReturnDataUpdateContent;
import com.google.code.ssm.api.ReturnValueKeyProvider;
import com.google.code.ssm.api.UpdateAssignCache;
import com.google.code.ssm.api.UpdateMultiCache;
import com.google.code.ssm.api.UpdateSingleCache;
import com.google.code.ssm.api.counter.DecrementCounterInCache;
import com.google.code.ssm.api.counter.IncrementCounterInCache;
import com.google.code.ssm.api.counter.ReadCounterFromCache;
import com.google.code.ssm.api.counter.UpdateCounterInCache;
import com.google.code.ssm.util.ImmutableSet;
import com.google.code.ssm.util.Utils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class AnnotationDataBuilder {
    private static final Comparator<ParameterValueKeyProvider> COMPARATOR = new ParameterValueKeyProviderComparator();
    private static final Set<Class<? extends Annotation>> ASSIGNS = ImmutableSet.of(ReadThroughAssignCache.class, UpdateAssignCache.class, InvalidateAssignCache.class);
    private static final Set<Class<? extends Annotation>> MULTIS = ImmutableSet.of(ReadThroughMultiCache.class, UpdateMultiCache.class, InvalidateMultiCache.class);
    private static final Set<Class<? extends Annotation>> READS = ImmutableSet.of(ReadThroughAssignCache.class, ReadThroughSingleCache.class, ReadThroughMultiCache.class, ReadCounterFromCache.class);
    private static final Set<Class<? extends Annotation>> INVALIDATES = ImmutableSet.of(InvalidateAssignCache.class, InvalidateSingleCache.class, InvalidateMultiCache.class);
    private static final Set<Class<? extends Annotation>> UPDATES = ImmutableSet.of(UpdateSingleCache.class, UpdateMultiCache.class, UpdateAssignCache.class, UpdateCounterInCache.class);
    private static final Set<Class<? extends Annotation>> INCDEC = ImmutableSet.of(IncrementCounterInCache.class, DecrementCounterInCache.class);

    private AnnotationDataBuilder() {
    }

    public static AnnotationData buildAnnotationData(Annotation annotation, Class<? extends Annotation> expectedAnnotationClass, Method targetMethod) {
        AnnotationData data = new AnnotationData();
        AnnotationDataBuilder.populateClassName(data, annotation, expectedAnnotationClass);
        try {
            AnnotationDataBuilder.populateCacheName(data, targetMethod);
            AnnotationDataBuilder.populateKeyIndexes(data, expectedAnnotationClass, targetMethod);
            AnnotationDataBuilder.populateDataIndexFromAnnotations(data, expectedAnnotationClass, targetMethod);
            AnnotationDataBuilder.populateExpiration(data, annotation, expectedAnnotationClass, targetMethod.getName());
            AnnotationDataBuilder.populateNamespace(data, annotation, expectedAnnotationClass, targetMethod.getName());
            AnnotationDataBuilder.populateAssignedKey(data, annotation, expectedAnnotationClass, targetMethod.getName());
            AnnotationDataBuilder.populateListKeyIndex(data, expectedAnnotationClass, targetMethod);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Problem assembling Annotation information.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Problem assembling Annotation information.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Problem assembling Annotation information.", ex);
        }
        return data;
    }

    static void populateCacheName(AnnotationData data, Method targetMethod) {
        CacheName cache = targetMethod.getAnnotation(CacheName.class);
        if (cache == null) {
            cache = targetMethod.getDeclaringClass().getAnnotation(CacheName.class);
        }
        if (cache != null) {
            data.setCacheName(cache.value());
        }
    }

    static void populateAssignedKey(AnnotationData data, Annotation annotation, Class<? extends Annotation> expectedAnnotationClass, String targetMethodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (ASSIGNS.contains(expectedAnnotationClass)) {
            Method assignKeyMethod = expectedAnnotationClass.getDeclaredMethod("assignedKey", null);
            String assignKey = (String)assignKeyMethod.invoke((Object)annotation, (Object[])null);
            if ("[unassigned]".equals(assignKey) || assignKey == null || assignKey.length() < 1) {
                throw new InvalidParameterException(String.format("AssignedKey for annotation [%s] must be defined on [%s]", expectedAnnotationClass.getName(), targetMethodName));
            }
            data.setAssignedKey(assignKey);
        }
    }

    static void populateNamespace(AnnotationData data, Annotation annotation, Class<? extends Annotation> expectedAnnotationClass, String targetMethodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method namespaceMethod = expectedAnnotationClass.getDeclaredMethod("namespace", null);
        String namespace = (String)namespaceMethod.invoke((Object)annotation, (Object[])null);
        if ("[unassigned]".equals(namespace) || namespace == null || namespace.length() < 1) {
            throw new InvalidParameterException(String.format("Namespace for annotation [%s] must be defined on [%s]", expectedAnnotationClass.getName(), targetMethodName));
        }
        data.setNamespace(namespace);
    }

    static void populateExpiration(AnnotationData data, Annotation annotation, Class<? extends Annotation> expectedAnnotationClass, String targetMethodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!INVALIDATES.contains(expectedAnnotationClass) && !INCDEC.contains(expectedAnnotationClass)) {
            Method expirationMethod = expectedAnnotationClass.getDeclaredMethod("expiration", null);
            int expiration = (Integer)expirationMethod.invoke((Object)annotation, (Object[])null);
            if (expiration < 0) {
                throw new InvalidParameterException(String.format("Expiration for annotation [%s] must be 0 or greater on [%s]", expectedAnnotationClass.getName(), targetMethodName));
            }
            data.setExpiration(expiration);
        }
    }

    static void populateDataIndexFromAnnotations(AnnotationData data, Class<? extends Annotation> expectedAnnotationClass, Method targetMethod) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!UPDATES.contains(expectedAnnotationClass)) {
            return;
        }
        ReturnDataUpdateContent returnAnnotation = targetMethod.getAnnotation(ReturnDataUpdateContent.class);
        if (returnAnnotation != null) {
            if (targetMethod.getReturnType().equals(Void.TYPE)) {
                throw new InvalidParameterException(String.format("Annotation [%s] is defined on void method  [%s]", returnAnnotation, targetMethod.getName()));
            }
            data.setReturnDataIndex(true);
            return;
        }
        Annotation[][] paramAnnotationArrays = targetMethod.getParameterAnnotations();
        int foundIndex = Integer.MIN_VALUE;
        if (paramAnnotationArrays != null && paramAnnotationArrays.length > 0) {
            for (int ix = 0; ix < paramAnnotationArrays.length; ++ix) {
                if (AnnotationDataBuilder.getAnnotation(ParameterDataUpdateContent.class, paramAnnotationArrays[ix]) == null) continue;
                if (foundIndex >= 0) {
                    throw new InvalidParameterException(String.format("Multiple annotations of type [%s] found on method [%s]", ParameterDataUpdateContent.class.getName(), targetMethod.getName()));
                }
                foundIndex = ix;
            }
        }
        if (foundIndex < 0) {
            throw new InvalidParameterException(String.format("No ReturnDataUpdateContent or ParameterDataUpdateContent annotation found method [%s]", targetMethod.getName()));
        }
        data.setDataIndex(foundIndex);
    }

    static void populateKeyIndexes(AnnotationData data, Class<? extends Annotation> expectedAnnotationClass, Method targetMethod) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ReturnValueKeyProvider returnAnnotation;
        if (ASSIGNS.contains(expectedAnnotationClass)) {
            return;
        }
        if (!READS.contains(expectedAnnotationClass) && (returnAnnotation = targetMethod.getAnnotation(ReturnValueKeyProvider.class)) != null) {
            data.setReturnKeyIndex(true);
            return;
        }
        Annotation[][] paramAnnotationArrays = targetMethod.getParameterAnnotations();
        TreeMap<ParameterValueKeyProvider, Integer> founds = new TreeMap<ParameterValueKeyProvider, Integer>(COMPARATOR);
        HashSet<Integer> order = new HashSet<Integer>();
        if (paramAnnotationArrays != null && paramAnnotationArrays.length > 0) {
            for (int ix = 0; ix < paramAnnotationArrays.length; ++ix) {
                ParameterValueKeyProvider foundAnnotation = AnnotationDataBuilder.getAnnotation(ParameterValueKeyProvider.class, paramAnnotationArrays[ix]);
                if (foundAnnotation == null) continue;
                if (foundAnnotation.order() < 0) {
                    throw new InvalidParameterException(String.format("No valid order [%d] defined in annotation [%s] on method [%s], only no negative integers are allowed.", foundAnnotation.order(), ParameterValueKeyProvider.class.getName(), targetMethod.getName()));
                }
                if (!order.add(foundAnnotation.order())) {
                    throw new InvalidParameterException(String.format("No valid order defined in annotation [%s] on method [%s]. There are two annotations with the same order.", ParameterValueKeyProvider.class.getName(), targetMethod.getName()));
                }
                founds.put(foundAnnotation, ix);
            }
        }
        if (founds.isEmpty()) {
            throw new InvalidParameterException(String.format("No KeyProvider annotation found method [%s]", targetMethod.getName()));
        }
        data.setKeyIndexes(founds.values());
    }

    static void populateClassName(AnnotationData data, Annotation annotation, Class<? extends Annotation> expectedAnnotationClass) {
        if (annotation == null) {
            throw new InvalidParameterException(String.format("No annotation of type [%s] found.", expectedAnnotationClass.getName()));
        }
        Class<? extends Annotation> clazz = annotation.annotationType();
        if (!expectedAnnotationClass.equals(clazz)) {
            throw new InvalidParameterException(String.format("No annotation of type [%s] found, class was of type [%s].", expectedAnnotationClass.getName(), clazz.getName()));
        }
        data.setClassName(clazz.getName());
    }

    static void populateListKeyIndex(AnnotationData data, Class<? extends Annotation> expectedAnnotationClass, Method targetMethod) {
        if (data.getKeyIndexes().isEmpty() || !MULTIS.contains(expectedAnnotationClass)) {
            return;
        }
        Class<?>[] keyMethodParamTypes = Utils.getMethodParameterTypes(data.getKeyIndexes(), targetMethod);
        Integer[] keyIndexArray = data.getKeyIndexes().toArray(new Integer[data.getKeyIndexes().size()]);
        boolean listOccured = false;
        for (int i = 0; i < keyMethodParamTypes.length; ++i) {
            if (!AnnotationDataBuilder.verifyTypeIsList(keyMethodParamTypes[i])) continue;
            if (listOccured) {
                throw new InvalidAnnotationException("There are more than one method's parameter annotated by @ParameterValueKeyProvider that is list " + targetMethod.toString());
            }
            listOccured = true;
            data.setListIndexInKeys(i);
            data.setListIndexInMethodArgs(keyIndexArray[i]);
        }
        if (!listOccured) {
            throw new InvalidAnnotationException(String.format("No one parameter objects found at dataIndexes [%s] is not a [%s]. [%s] does not fulfill the requirements.", data.getKeyIndexes(), List.class.getName(), targetMethod.toString()));
        }
    }

    private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, Annotation[] annotations) {
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!annotationClass.equals(annotation.annotationType())) continue;
                return (T)annotation;
            }
        }
        return null;
    }

    private static boolean verifyTypeIsList(Class<?> clazz) {
        return List.class.isAssignableFrom(clazz);
    }

    private static class ParameterValueKeyProviderComparator
    implements Comparator<ParameterValueKeyProvider>,
    Serializable {
        private static final long serialVersionUID = 2791887056140560908L;

        private ParameterValueKeyProviderComparator() {
        }

        @Override
        public int compare(ParameterValueKeyProvider o1, ParameterValueKeyProvider o2) {
            return o1.order() - o2.order();
        }
    }
}

