/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.support;

import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.CacheKeyBuilder;
import com.google.code.ssm.aop.support.DefaultKeyProvider;
import com.google.code.ssm.aop.support.KeyProvider;
import com.google.code.ssm.util.Utils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

public class CacheKeyBuilderImpl
implements CacheKeyBuilder {
    private static final String SEPARATOR = ":";
    private static final String ID_SEPARATOR = "/";
    private KeyProvider defaultKeyProvider = new DefaultKeyProvider();

    public void setDefaultKeyProvider(KeyProvider defaultKeyProvider) {
        this.defaultKeyProvider = defaultKeyProvider;
    }

    public KeyProvider getDefaultKeyProvider() {
        return this.defaultKeyProvider;
    }

    @Override
    public String getCacheKey(AnnotationData data, Object[] args, String methodDesc) throws Exception {
        Object[] keysObjects = Utils.getMethodArgs(data.getKeyIndexes(), args, methodDesc);
        return this.getCacheKey(keysObjects, data.getNamespace());
    }

    @Override
    public String getCacheKey(Object keyObject, String namespace) {
        return namespace + SEPARATOR + this.defaultKeyProvider.generateKey(keyObject);
    }

    @Override
    public List<String> getCacheKeys(List<Object> keyObjects, String namespace) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        for (Object object : keyObjects) {
            String objectId = this.defaultKeyProvider.generateKey(object);
            results.add(this.getCacheKey(objectId, namespace));
        }
        return results;
    }

    @Override
    public List<String> getCacheKeys(AnnotationData data, Object[] args, String methodDesc) {
        List listObjects = (List)args[data.getListIndexInMethodArgs()];
        ArrayList<String> cacheKeys = new ArrayList<String>(listObjects.size());
        Object[] keyObjects = Utils.getMethodArgs(data.getKeyIndexes(), args, methodDesc);
        Object[] keys = new Object[keyObjects.length];
        System.arraycopy(keyObjects, 0, keys, 0, keys.length);
        for (Object obj : listObjects) {
            if (obj == null) {
                throw new InvalidParameterException("One of the passed in key objects is null");
            }
            keys[data.getListIndexInKeys()] = obj;
            cacheKeys.add(this.getCacheKey(keys, data.getNamespace()));
        }
        return cacheKeys;
    }

    @Override
    public String getAssignCacheKey(AnnotationData data) {
        if (data == null || data.getAssignedKey() == null || data.getAssignedKey().length() < 1) {
            throw new InvalidParameterException("Ids for objects in the cache must be at least 1 character long.");
        }
        return data.getNamespace() + SEPARATOR + data.getAssignedKey();
    }

    private String getCacheKey(Object[] keyObjects, String namespace) {
        if (keyObjects == null || keyObjects.length < 1) {
            throw new InvalidParameterException("Ids for objects in the cache must be at least 1 character long.");
        }
        String[] objectIds = this.defaultKeyProvider.generateKeys(keyObjects);
        return this.buildCacheKey(objectIds, namespace);
    }

    private String buildCacheKey(String[] objectIds, String namespace) {
        if (objectIds.length == 1) {
            this.checkKeyPart(objectIds[0]);
            return namespace + SEPARATOR + objectIds[0];
        }
        StringBuilder cacheKey = new StringBuilder(namespace);
        cacheKey.append(SEPARATOR);
        for (String id : objectIds) {
            this.checkKeyPart(id);
            cacheKey.append(id);
            cacheKey.append(ID_SEPARATOR);
        }
        cacheKey.deleteCharAt(cacheKey.length() - 1);
        return cacheKey.toString();
    }

    private void checkKeyPart(String keyPart) {
        if (keyPart == null || keyPart.length() < 1) {
            throw new InvalidParameterException("Ids for objects in the cache must be at least 1 character long.");
        }
    }
}

