/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.json;

import com.google.code.ssm.json.ClassAliasIdResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeIdResolver;
import org.codehaus.jackson.type.JavaType;
import org.springframework.util.Assert;

public class ClassAliasTypeResolverBuilder
extends ObjectMapper.DefaultTypeResolverBuilder {
    private Map<String, Class<?>> idToClass = new HashMap();
    private Map<Class<?>, String> classToId = new HashMap();

    public ClassAliasTypeResolverBuilder(ObjectMapper.DefaultTyping typing) {
        super(typing);
    }

    protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        return new ClassAliasIdResolver(baseType, config.getTypeFactory(), this.idToClass, this.classToId);
    }

    public void setClassToId(Map<Class<?>, String> classToId) {
        HashMap reverseMap = new HashMap();
        for (Map.Entry<Class<?>, String> entry : classToId.entrySet()) {
            Assert.notNull(entry.getKey(), (String)("Class cannot be null: " + entry));
            Assert.hasText((String)entry.getValue(), (String)("Alias (id) cannot be null or contain only whitespaces" + entry));
            if (reverseMap.put(entry.getValue(), entry.getKey()) == null) continue;
            throw new IllegalArgumentException("Two or more classes with the same alias (id): " + entry.getValue());
        }
        this.classToId = classToId;
        this.idToClass = reverseMap;
    }
}

