/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop;

import com.google.code.ssm.aop.CacheAdvice;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.aop.support.InvalidAnnotationException;
import com.google.code.ssm.api.InvalidateMultiCache;
import java.lang.reflect.Method;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class InvalidateMultiCacheAdvice
extends CacheAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidateMultiCacheAdvice.class);

    @Pointcut(value="@annotation(com.google.code.ssm.api.InvalidateMultiCache)")
    public void invalidateMulti() {
    }

    @Around(value="invalidateMulti()")
    public Object cacheInvalidateMulti(ProceedingJoinPoint pjp) throws Throwable {
        AnnotationData data;
        Method methodToCache;
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return pjp.proceed();
        }
        List<String> cacheKeys = null;
        try {
            methodToCache = this.getCacheBase().getMethodToCache((JoinPoint)pjp, InvalidateMultiCache.class);
            InvalidateMultiCache annotation = methodToCache.getAnnotation(InvalidateMultiCache.class);
            data = AnnotationDataBuilder.buildAnnotationData(annotation, InvalidateMultiCache.class, methodToCache);
            if (!data.isReturnKeyIndex()) {
                cacheKeys = this.getCacheBase().getCacheKeyBuilder().getCacheKeys(data, pjp.getArgs(), methodToCache.toString());
            }
        }
        catch (Exception ex) {
            this.warn(ex, "Caching on method %s aborted due to an error.", pjp.toShortString());
            return pjp.proceed();
        }
        Object result = pjp.proceed();
        try {
            if (data.isReturnKeyIndex()) {
                if (!this.getCacheBase().verifyTypeIsList(result.getClass())) {
                    throw new InvalidAnnotationException(String.format("The return type is not a [%s]. The method [%s] does not fulfill the requirements.", List.class.getName(), methodToCache.toString()));
                }
                List keyObjects = (List)result;
                cacheKeys = this.getCacheBase().getCacheKeyBuilder().getCacheKeys(keyObjects, data.getNamespace());
            }
            this.getCacheBase().getCache(data).delete(cacheKeys);
        }
        catch (Exception ex) {
            this.warn(ex, "Caching on method %s aborted due to an error.", pjp.toShortString());
        }
        return result;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

