/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop;

import com.google.code.ssm.aop.CacheAdvice;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.api.InvalidateSingleCache;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class InvalidateSingleCacheAdvice
extends CacheAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidateSingleCacheAdvice.class);

    @Pointcut(value="@annotation(com.google.code.ssm.api.InvalidateSingleCache)")
    public void invalidateSingle() {
    }

    @Around(value="invalidateSingle()")
    public Object cacheInvalidateSingle(ProceedingJoinPoint pjp) throws Throwable {
        AnnotationData data;
        Method methodToCache;
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return pjp.proceed();
        }
        String cacheKey = null;
        try {
            methodToCache = this.getCacheBase().getMethodToCache((JoinPoint)pjp, InvalidateSingleCache.class);
            InvalidateSingleCache annotation = methodToCache.getAnnotation(InvalidateSingleCache.class);
            data = AnnotationDataBuilder.buildAnnotationData(annotation, InvalidateSingleCache.class, methodToCache);
            if (!data.isReturnKeyIndex()) {
                cacheKey = this.getCacheBase().getCacheKeyBuilder().getCacheKey(data, pjp.getArgs(), methodToCache.toString());
            }
        }
        catch (Exception ex) {
            this.warn(ex, "Caching on method %s and key [%s] aborted due to an error.", pjp.toShortString(), cacheKey);
            return pjp.proceed();
        }
        Object result = pjp.proceed();
        try {
            if (data.isReturnKeyIndex()) {
                this.getCacheBase().verifyReturnTypeIsNoVoid(methodToCache, InvalidateSingleCache.class);
                cacheKey = this.getCacheBase().getCacheKeyBuilder().getCacheKey(result, data.getNamespace());
            }
            this.getCacheBase().getCache(data).delete(cacheKey);
        }
        catch (Exception ex) {
            this.warn(ex, "Caching on method %s and key [%s] aborted due to an error.", pjp.toShortString(), cacheKey);
        }
        return result;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

