/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop;

import com.google.code.ssm.aop.MultiCacheAdvice;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.aop.support.InvalidAnnotationException;
import com.google.code.ssm.api.UpdateMultiCache;
import com.google.code.ssm.api.UpdateMultiCacheOption;
import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.util.Utils;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class UpdateMultiCacheAdvice
extends MultiCacheAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateMultiCacheAdvice.class);

    @Pointcut(value="@annotation(com.google.code.ssm.api.UpdateMultiCache)")
    public void updateMulti() {
    }

    @AfterReturning(pointcut="updateMulti()", returning="retVal")
    public void cacheUpdateMulti(JoinPoint jp, Object retVal) throws Throwable {
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return;
        }
        try {
            List<String> cacheKeys;
            Method methodToCache = this.getCacheBase().getMethodToCache(jp, UpdateMultiCache.class);
            UpdateMultiCache annotation = methodToCache.getAnnotation(UpdateMultiCache.class);
            AnnotationData data = AnnotationDataBuilder.buildAnnotationData(annotation, UpdateMultiCache.class, methodToCache);
            List dataList = (List)this.getCacheBase().getUpdateData(data, methodToCache, jp.getArgs(), retVal);
            SerializationType serializationType = this.getCacheBase().getSerializationType(methodToCache);
            MultiCacheAdvice.MultiCacheCoordinator coord = new MultiCacheAdvice.MultiCacheCoordinator(methodToCache, data);
            coord.setAddNullsToCache(annotation.option().addNullsToCache());
            if (data.isReturnKeyIndex()) {
                List keyObjects = (List)retVal;
                coord.setHolder(this.convertIdObjectsToKeyMap(keyObjects, data));
                cacheKeys = this.getCacheBase().getCacheKeyBuilder().getCacheKeys(keyObjects, data.getNamespace());
            } else {
                coord.setHolder(this.createObjectIdCacheKeyMapping(coord.getAnnotationData(), jp.getArgs(), coord.getMethod()));
                List listKeyObjects = (List)Utils.getMethodArg(data.getListIndexInMethodArgs(), jp.getArgs(), methodToCache.toString());
                coord.setListKeyObjects(listKeyObjects);
                cacheKeys = new ArrayList<String>(coord.getKey2Obj().keySet());
            }
            if (!annotation.option().addNullsToCache()) {
                this.updateCache(cacheKeys, dataList, methodToCache, data, serializationType);
            } else {
                HashMap<String, Object> key2Result = new HashMap<String, Object>();
                for (String cacheKey : cacheKeys) {
                    key2Result.put(cacheKey, null);
                }
                coord.setInitialKey2Result(key2Result);
                this.updateCacheWithMissed(dataList, coord, annotation.option(), serializationType);
            }
        }
        catch (Exception ex) {
            this.warn(ex, "Updating caching via %s aborted due to an error.", jp.toShortString());
        }
    }

    MultiCacheAdvice.MapHolder convertIdObjectsToKeyMap(List<Object> idObjects, AnnotationData data) throws Exception {
        MultiCacheAdvice.MapHolder holder = new MultiCacheAdvice.MapHolder();
        for (Object obj : idObjects) {
            if (obj == null) {
                throw new InvalidParameterException("One of the passed in key objects is null");
            }
            String cacheKey = this.getCacheBase().getCacheKeyBuilder().getCacheKey(obj, data.getNamespace());
            if (holder.getObj2Key().get(obj) == null) {
                holder.getObj2Key().put(obj, cacheKey);
            }
            if (holder.getKey2Obj().get(cacheKey) != null) continue;
            holder.getKey2Obj().put(cacheKey, obj);
        }
        return holder;
    }

    void updateCache(List<String> cacheKeys, List<Object> returnList, Method methodToCache, AnnotationData data, SerializationType serializationType) {
        if (returnList.size() != cacheKeys.size()) {
            throw new InvalidAnnotationException(String.format("The key generation objects, and the resulting objects do not match in size for [%s].", methodToCache.toString()));
        }
        Iterator<Object> returnListIter = returnList.iterator();
        Iterator<String> cacheKeyIter = cacheKeys.iterator();
        while (returnListIter.hasNext()) {
            Object result = returnListIter.next();
            String cacheKey = cacheKeyIter.next();
            Object cacheObject = this.getCacheBase().getSubmission(result);
            this.getCacheBase().getCache(data).setSilently(cacheKey, data.getExpiration(), cacheObject, serializationType);
        }
    }

    private void updateCacheWithMissed(List<Object> dataUpdateContents, MultiCacheAdvice.MultiCacheCoordinator coord, UpdateMultiCacheOption option, SerializationType serializationType) throws Exception {
        if (!dataUpdateContents.isEmpty()) {
            List<String> cacheKeys = this.getCacheBase().getCacheKeyBuilder().getCacheKeys(dataUpdateContents, coord.getAnnotationData().getNamespace());
            Iterator<String> iter = cacheKeys.iterator();
            for (Object resultObject : dataUpdateContents) {
                String cacheKey = iter.next();
                this.getCacheBase().getCache(coord.getAnnotationData()).setSilently(cacheKey, coord.getAnnotationData().getExpiration(), resultObject, serializationType);
                coord.getMissedObjects().remove(coord.getKey2Obj().get(cacheKey));
            }
        }
        if (option.overwriteNoNulls()) {
            this.setNullValues(coord.getMissedObjects(), coord, serializationType);
        } else {
            this.addNullValues(coord.getMissedObjects(), coord, serializationType);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

