/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.support.builder;

import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.builder.AbstractDataBuilder;
import com.google.code.ssm.api.CacheOperation;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReturnValueKeyProvider;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyIndexesBuilder
extends AbstractDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(KeyIndexesBuilder.class);
    private static final Comparator<ParameterValueKeyProvider> COMPARATOR = new ParameterValueKeyProviderComparator();

    @Override
    protected void build(AnnotationData data, Annotation annotation, Class<? extends Annotation> expectedAnnotationClass, Method targetMethod) {
        ReturnValueKeyProvider returnAnnotation;
        if (!this.isType(expectedAnnotationClass, CacheOperation.Type.READ) && (returnAnnotation = targetMethod.getAnnotation(ReturnValueKeyProvider.class)) != null) {
            data.setReturnKeyIndex(true);
            return;
        }
        boolean isMulti = this.isType(expectedAnnotationClass, CacheOperation.Type.MULTI);
        Collection<Integer> keyIndexes = this.getKeyIndexes(targetMethod, isMulti);
        if (keyIndexes.isEmpty()) {
            throw new InvalidParameterException(String.format("No KeyProvider annotation found method [%s]", targetMethod.getName()));
        }
        data.setKeyIndexes(keyIndexes);
    }

    @Override
    protected boolean support(Class<? extends Annotation> expectedAnnotationClass) {
        return !this.isType(expectedAnnotationClass, CacheOperation.Type.ASSIGN);
    }

    private Collection<Integer> getKeyIndexes(Method targetMethod, boolean isMulti) {
        Annotation[][] paramAnnotationArrays = targetMethod.getParameterAnnotations();
        TreeMap<ParameterValueKeyProvider, Integer> keyProviders = new TreeMap<ParameterValueKeyProvider, Integer>(COMPARATOR);
        HashSet<Integer> order = new HashSet<Integer>();
        if (paramAnnotationArrays == null || paramAnnotationArrays.length < 1) {
            return Collections.emptyList();
        }
        for (int ix = 0; ix < paramAnnotationArrays.length; ++ix) {
            ParameterValueKeyProvider keyProviderAnnotation = this.getAnnotation(ParameterValueKeyProvider.class, paramAnnotationArrays[ix]);
            if (keyProviderAnnotation == null) continue;
            if (keyProviderAnnotation.order() < 0) {
                throw new InvalidParameterException(String.format("No valid order [%d] defined in annotation [%s] on method [%s], only no negative integers are allowed.", keyProviderAnnotation.order(), ParameterValueKeyProvider.class.getName(), targetMethod.getName()));
            }
            if (!order.add(keyProviderAnnotation.order())) {
                this.throwException("No valid order defined in annotation [%s] on method [%s]. There are two annotations with the same order.", ParameterValueKeyProvider.class, targetMethod);
            }
            if (!isMulti && Collection.class.isAssignableFrom(targetMethod.getParameterTypes()[ix])) {
                LOG.warn("ParameterValueKeyProvider is used on a list parameter {} in method {} with non multi cache annotation.Consider changing to *MultiCache annotation or use another parameter for key. Using collections in such case may lead to unexpected consequences: key can exceed allowed memcached key length, key will be varied when order or size are changed.", targetMethod.getParameterTypes()[ix], (Object)targetMethod.getName());
            }
            keyProviders.put(keyProviderAnnotation, ix);
        }
        return keyProviders.values();
    }

    private static class ParameterValueKeyProviderComparator
    implements Comparator<ParameterValueKeyProvider>,
    Serializable {
        private static final long serialVersionUID = 2791887056140560908L;

        private ParameterValueKeyProviderComparator() {
        }

        @Override
        public int compare(ParameterValueKeyProvider o1, ParameterValueKeyProvider o2) {
            return o1.order() - o2.order();
        }
    }
}

