/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.config;

import com.google.code.ssm.config.AddressProvider;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAddressProvider
implements AddressProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAddressProvider.class);
    private String address;

    public DefaultAddressProvider() {
    }

    public DefaultAddressProvider(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String addresses) {
        this.address = addresses;
    }

    @Override
    public List<InetSocketAddress> getAddresses() {
        LOGGER.info(String.format("Defined values %s will be used as memcached addresses", this.getAddress()));
        return this.getAddresses(this.address);
    }

    protected List<InetSocketAddress> getAddresses(String s) {
        if (s == null) {
            throw new NullPointerException("Null host list");
        }
        if (s.trim().isEmpty()) {
            throw new IllegalArgumentException("No hosts in list: '" + s + "'");
        }
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        for (String hoststuff : s.split("(?:\\s|,)+")) {
            if ("".equals(hoststuff)) continue;
            int finalColon = hoststuff.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server '" + hoststuff + "' in list:  " + s);
            }
            String hostPart = hoststuff.substring(0, finalColon);
            String portNum = hoststuff.substring(finalColon + 1);
            addrs.add(new InetSocketAddress(hostPart, Integer.parseInt(portNum)));
        }
        return addrs;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

