/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.transcoders;

import com.google.code.ssm.providers.CacheTranscoder;
import com.google.code.ssm.providers.CachedObject;
import com.google.code.ssm.providers.CachedObjectImpl;
import java.io.UnsupportedEncodingException;

public class LongToStringTranscoder
implements CacheTranscoder {
    @Override
    public Object decode(CachedObject data) {
        byte[] value = data.getData();
        if (value == null || value.length == 0) {
            return null;
        }
        try {
            return Long.parseLong(new String(value, "UTF-8").trim());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CachedObject encode(Object o) {
        if (!(o instanceof Long)) {
            throw new IllegalArgumentException("Only Long objects are supported by this transcoder");
        }
        try {
            return new CachedObjectImpl(0, String.valueOf(o).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "LongToStringTranscoder()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongToStringTranscoder)) {
            return false;
        }
        LongToStringTranscoder other = (LongToStringTranscoder)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof LongToStringTranscoder;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

