/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm;

import com.google.code.ssm.CacheProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;

public class DisabledCacheInvocationHandler
implements InvocationHandler {
    private final String cacheName;
    private final Collection<String> cacheAliases;
    private final CacheProperties cacheProperties = new CacheProperties();

    public DisabledCacheInvocationHandler(String cacheName, Collection<String> cacheAliases) {
        this.cacheName = cacheName;
        this.cacheAliases = cacheAliases;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getName".equals(methodName)) {
            return this.cacheName;
        }
        if ("getAliases".equals(methodName)) {
            return this.cacheAliases;
        }
        if ("isEnabled".equals(methodName)) {
            return false;
        }
        if ("shutdown".equals(methodName)) {
            return null;
        }
        if ("getProperties".equals(methodName)) {
            return this.cacheProperties;
        }
        throw new IllegalStateException(String.format("Cache with name %s and aliases %s is disabled for method %s", this.cacheName, this.cacheAliases, methodName));
    }
}

