/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm;

import com.google.code.ssm.Cache;
import com.google.code.ssm.CacheProperties;
import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.providers.CacheException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class PrefixedCacheImpl
implements Cache {
    private final Cache cache;
    private final String name;
    private final String namePrefixSeparator;

    public PrefixedCacheImpl(Cache cache, String requestedName, String namePrefixSeparator) {
        this.cache = cache;
        this.name = requestedName;
        this.namePrefixSeparator = namePrefixSeparator;
    }

    @Override
    public Collection<SocketAddress> getAvailableServers() {
        return this.cache.getAvailableServers();
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public Collection<String> getAliases() {
        return this.cache.getAliases();
    }

    @Override
    public CacheProperties getProperties() {
        return this.cache.getProperties();
    }

    @Override
    public <T> boolean add(String key, int exp, Object value, SerializationType serializationType) throws TimeoutException, CacheException {
        return this.cache.add(this.alterKey(key), exp, value, serializationType);
    }

    @Override
    public <T> boolean addSilently(String cacheKey, int expiration, Object value, SerializationType serializationType) {
        return this.cache.addSilently(this.alterKey(cacheKey), expiration, value, serializationType);
    }

    @Override
    public long decr(String key, int by) throws TimeoutException, CacheException {
        return this.cache.decr(this.alterKey(key), by);
    }

    @Override
    public boolean delete(String key) throws TimeoutException, CacheException {
        return this.cache.delete(this.alterKey(key));
    }

    @Override
    public void delete(Collection<String> keys) throws TimeoutException, CacheException {
        this.cache.delete(this.alterKeys(keys));
    }

    @Override
    public void flush() throws TimeoutException, CacheException {
        this.cache.flush();
    }

    @Override
    public <T> T get(String key, SerializationType serializationType) throws TimeoutException, CacheException {
        return this.cache.get(this.alterKey(key), serializationType);
    }

    @Override
    public Map<String, Object> getBulk(Collection<String> keys, SerializationType serializationType) throws TimeoutException, CacheException {
        Map<String, Object> results = this.cache.getBulk(this.alterKeys(keys), serializationType);
        return this.removeCacheNames(results);
    }

    @Override
    public long incr(String key, int by, long def) throws TimeoutException, CacheException {
        return this.cache.incr(this.alterKey(key), by, def);
    }

    @Override
    public long incr(String key, int by, long def, int exp) throws TimeoutException, CacheException {
        return this.cache.incr(this.alterKey(key), by, def, exp);
    }

    @Override
    public boolean isEnabled() {
        return this.cache.isEnabled();
    }

    @Override
    public <T> void set(String key, int exp, Object value, SerializationType serializationType) throws TimeoutException, CacheException {
        this.cache.set(this.alterKey(key), exp, value, serializationType);
    }

    @Override
    public <T> void setSilently(String cacheKey, int expiration, Object value, SerializationType serializationType) {
        this.cache.setSilently(this.alterKey(cacheKey), expiration, value, serializationType);
    }

    @Override
    public Long getCounter(String cacheKey) throws TimeoutException, CacheException {
        return this.cache.getCounter(this.alterKey(cacheKey));
    }

    @Override
    public void setCounter(String cacheKey, int expiration, long value) throws TimeoutException, CacheException {
        this.cache.setCounter(this.alterKey(cacheKey), expiration, value);
    }

    @Override
    public void shutdown() {
        this.cache.shutdown();
    }

    @Override
    public Object getNativeClient() {
        return this.cache.getNativeClient();
    }

    private String alterKey(String cacheKey) {
        return this.name + this.namePrefixSeparator + cacheKey;
    }

    private Collection<String> alterKeys(Collection<String> keys) {
        ArrayList<String> alteredKeys = new ArrayList<String>(keys.size());
        for (String key : keys) {
            alteredKeys.add(this.alterKey(key));
        }
        return alteredKeys;
    }

    private Map<String, Object> removeCacheNames(Map<String, Object> resultsWithCacheName) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : resultsWithCacheName.entrySet()) {
            String key = entry.getKey().substring((this.name + this.namePrefixSeparator).length());
            results.put(key, entry.getValue());
        }
        return results;
    }
}

