/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.counter;

import com.google.code.ssm.aop.counter.CounterInCacheBase;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.AnnotationDataBuilder;
import com.google.code.ssm.api.counter.UpdateCounterInCache;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class UpdateCounterInCacheAdvice
extends CounterInCacheBase {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateCounterInCacheAdvice.class);

    @Pointcut(value="@annotation(com.google.code.ssm.api.counter.UpdateCounterInCache)")
    public void updateCounter() {
    }

    @AfterReturning(pointcut="updateCounter()", returning="retVal")
    public void cacheCounterInCache(JoinPoint jp, Object retVal) throws Throwable {
        if (this.isDisabled()) {
            this.getLogger().info("Cache disabled");
            return;
        }
        String cacheKey = null;
        try {
            Method methodToCache = this.getCacheBase().getMethodToCache(jp, UpdateCounterInCache.class);
            UpdateCounterInCache annotation = methodToCache.getAnnotation(UpdateCounterInCache.class);
            AnnotationData data = AnnotationDataBuilder.buildAnnotationData(annotation, UpdateCounterInCache.class, methodToCache);
            cacheKey = this.getCacheBase().getCacheKeyBuilder().getCacheKey(data, jp.getArgs(), methodToCache.toString());
            Object dataObject = this.getCacheBase().getUpdateData(data, methodToCache, jp.getArgs(), retVal);
            if (this.checkData(dataObject, jp)) {
                long value = ((Number)dataObject).longValue();
                this.getCacheBase().getCache(data).setCounter(cacheKey, annotation.expiration(), value);
            }
        }
        catch (Exception ex) {
            this.warn(ex, "Updating counter [%s] in cache via %s aborted due to an error.", cacheKey, jp.toShortString());
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

