/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.support.builder;

import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.api.CacheOperation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;

public abstract class AbstractDataBuilder {
    public void populate(AnnotationData data, Annotation annotation, Class<? extends Annotation> expectedAnnotationClass, Method targetMethod) throws Exception {
        if (this.support(expectedAnnotationClass)) {
            this.build(data, annotation, expectedAnnotationClass, targetMethod);
        }
    }

    protected abstract void build(AnnotationData var1, Annotation var2, Class<? extends Annotation> var3, Method var4) throws Exception;

    protected boolean support(Class<? extends Annotation> expectedAnnotationClass) {
        return true;
    }

    protected boolean isType(Class<?> clazz, CacheOperation.Type type) {
        CacheOperation operation = clazz.getAnnotation(CacheOperation.class);
        if (operation == null) {
            return false;
        }
        for (CacheOperation.Type operationType : operation.value()) {
            if (!type.equals((Object)operationType)) continue;
            return true;
        }
        return false;
    }

    protected <T extends Annotation> T getAnnotation(Class<T> annotationClass, Annotation[] annotations) {
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!annotationClass.equals(annotation.annotationType())) continue;
                return (T)annotation;
            }
        }
        return null;
    }

    protected void throwException(String msg, Class<? extends Annotation> clazz, Method method) {
        throw new InvalidParameterException(String.format(msg, clazz.getName(), method.getName()));
    }

    protected <T> T invokeMethod(Annotation annotation, Class<? extends Annotation> annotationClass, String methodName) throws Exception {
        Method method = annotationClass.getDeclaredMethod(methodName, null);
        return (T)method.invoke((Object)annotation, (Object[])null);
    }
}

