/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.support.builder;

import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.InvalidAnnotationException;
import com.google.code.ssm.aop.support.builder.AbstractDataBuilder;
import com.google.code.ssm.api.CacheOperation;
import com.google.code.ssm.util.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

public class ListKeyIndexBuilder
extends AbstractDataBuilder {
    @Override
    protected void build(AnnotationData data, Annotation annotation, Class<? extends Annotation> expectedAnnotationClass, Method targetMethod) throws Exception {
        if (data.getKeyIndexes().isEmpty()) {
            return;
        }
        Class<?>[] keyMethodParamTypes = Utils.getMethodParameterTypes(data.getKeyIndexes(), targetMethod);
        Integer[] keyIndexes = data.getKeyIndexes().toArray(new Integer[data.getKeyIndexes().size()]);
        Integer listIndexInKeys = this.getListIndexInKeys(keyMethodParamTypes, targetMethod);
        if (listIndexInKeys == null) {
            throw new InvalidAnnotationException(String.format("No one parameter objects found at dataIndexes [%s] is not a [%s]. [%s] does not fulfill the requirements.", data.getKeyIndexes(), List.class.getName(), targetMethod.toString()));
        }
        data.setListIndexInKeys(listIndexInKeys);
        data.setListIndexInMethodArgs(keyIndexes[listIndexInKeys]);
    }

    @Override
    protected boolean support(Class<? extends Annotation> expectedAnnotationClass) {
        return this.isType(expectedAnnotationClass, CacheOperation.Type.MULTI);
    }

    private Integer getListIndexInKeys(Class<?>[] keyMethodParamTypes, Method targetMethod) {
        Integer listIndexInKeys = null;
        for (int i = 0; i < keyMethodParamTypes.length; ++i) {
            if (!this.isList(keyMethodParamTypes[i])) continue;
            if (listIndexInKeys != null) {
                throw new InvalidAnnotationException("There are more than one method's parameter annotated by @ParameterValueKeyProvider that is list " + targetMethod.toString());
            }
            listIndexInKeys = i;
        }
        return listIndexInKeys;
    }

    private boolean isList(Class<?> clazz) {
        return List.class.isAssignableFrom(clazz);
    }
}

