/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.json;

import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.code.ssm.aop.support.PertinentNegativeNull;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class ClassAliasIdResolver
extends ClassNameIdResolver {
    private final Map<String, Class<?>> idToClass = new HashMap();
    private final Map<Class<?>, String> classToId = new HashMap();

    public ClassAliasIdResolver(JavaType baseType, TypeFactory typeFactory, Map<String, Class<?>> idToClass, Map<Class<?>, String> classToId) {
        super(baseType, typeFactory);
        this.idToClass.putAll(idToClass);
        this.classToId.putAll(classToId);
        this.init();
    }

    public String idFromValue(Object value) {
        if (value != null) {
            return this.idFromValueAndType(value, value.getClass());
        }
        return this._idFrom(null, null, this._typeFactory);
    }

    public String idFromValueAndType(Object value, Class<?> type) {
        String id = null;
        if (type != null && (id = this.classToId.get(type)) != null) {
            return id;
        }
        return this._idFrom(value, type, this._typeFactory);
    }

    protected JavaType _typeFromId(String id, DatabindContext ctxt) throws IOException {
        Class<?> clazz = this.idToClass.get(id);
        if (clazz != null) {
            return this._typeFactory.constructSpecializedType(this._baseType, clazz);
        }
        return super._typeFromId(id, ctxt);
    }

    public void addClassToId(Class<?> clazz, String id) {
        Assert.notNull(clazz, (String)"Class cannot be null");
        Assert.hasText((String)id, (String)"Alias (id) cannot be null or contain only whitespaces");
        if (this.classToId.containsKey(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " has already defined alias (id) " + this.classToId.get(clazz) + " cannot set another alias " + id);
        }
        if (this.idToClass.containsKey(id)) {
            throw new IllegalArgumentException("Alias (id) " + id + " is used by another class " + this.idToClass.get(id) + " and cannot be used by " + clazz);
        }
        this.classToId.put(clazz, id);
        this.idToClass.put(id, clazz);
    }

    private void init() {
        this.addClassToId(PertinentNegativeNull.class, "N");
    }
}

