/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.mapper;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.code.ssm.json.ClassAliasTypeResolverBuilder;
import java.util.List;
import java.util.Map;

public class JsonObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    private final SimpleModule module = new SimpleModule("ssm", new Version(1, 0, 0, null, "com.google.code.ssm", "core"));
    private final ClassAliasTypeResolverBuilder typer;

    public JsonObjectMapper() {
        this.registerModule((Module)this.module);
        this.configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true);
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);
        this.typer = new ClassAliasTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL);
        this.setDefaultTyping((TypeResolverBuilder)this.typer.inclusion(JsonTypeInfo.As.WRAPPER_OBJECT));
    }

    public void setSerializers(List<JsonSerializer<?>> serializers) {
        for (JsonSerializer<?> serializer : serializers) {
            this.module.addSerializer(serializer);
        }
        this.registerModule((Module)this.module);
    }

    public void setSerializers(Map<Class<?>, JsonSerializer<?>> serializers) {
        for (Map.Entry<Class<?>, JsonSerializer<?>> entry : serializers.entrySet()) {
            this.module.addSerializer(entry.getKey(), entry.getValue());
        }
        this.registerModule((Module)this.module);
    }

    public void setDeserializers(Map<Class<?>, JsonDeserializer<?>> deserializers) {
        for (Map.Entry<Class<?>, JsonDeserializer<?>> entry : deserializers.entrySet()) {
            this.module.addDeserializer(entry.getKey(), entry.getValue());
        }
        this.registerModule((Module)this.module);
    }

    public void setClassToId(Map<Class<?>, String> classToId) {
        this.typer.setClassToId(classToId);
    }
}

