/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.spring;

import com.google.code.ssm.Cache;
import com.google.code.ssm.aop.support.PertinentNegativeNull;
import com.google.code.ssm.providers.CacheException;
import com.google.code.ssm.spring.WrappedCacheException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class SSMCache
implements org.springframework.cache.Cache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSMCache.class);
    private final Cache cache;
    private final int expiration;
    private final boolean allowClear;
    private final boolean muteExceptions;
    private final boolean registerAliases;

    public SSMCache(Cache cache, int expiration, boolean allowClear, boolean registerAliases, boolean muteExceptions) {
        this.cache = cache;
        this.expiration = expiration;
        this.allowClear = allowClear;
        this.registerAliases = registerAliases;
        this.muteExceptions = muteExceptions;
    }

    public SSMCache(Cache cache, int expiration, boolean allowClear) {
        this(cache, expiration, allowClear, false, false);
    }

    public SSMCache(Cache cache, int expiration) {
        this(cache, expiration, false);
    }

    public SSMCache(SSMCache ssmCache, int expiration) {
        this(ssmCache.cache, expiration, ssmCache.allowClear);
    }

    public String getName() {
        return this.cache.getName();
    }

    public Object getNativeCache() {
        return this.cache;
    }

    public Cache.ValueWrapper get(Object key) {
        if (!this.cache.isEnabled()) {
            LOGGER.warn("Cache {} is disabled. Cannot get {} from cache", (Object)this.cache.getName(), key);
            return null;
        }
        Object value = this.getValue(key);
        if (value == null) {
            LOGGER.info("Cache miss. Get by key {} from cache {}", key, (Object)this.cache.getName());
            return null;
        }
        LOGGER.info("Cache hit. Get by key {} from cache {} value '{}'", new Object[]{key, this.cache.getName(), value});
        return value instanceof PertinentNegativeNull ? new SimpleValueWrapper(null) : new SimpleValueWrapper(value);
    }

    public <T> T get(Object key, Class<T> type) {
        if (!this.cache.isEnabled()) {
            LOGGER.warn("Cache {} is disabled. Cannot get {} from cache", (Object)this.cache.getName(), key);
            return null;
        }
        Object value = this.getValue(key);
        if (value == null) {
            LOGGER.info("Cache miss. Get by key {} and type {} from cache {}", new Object[]{key, type, this.cache.getName()});
            return null;
        }
        if (value instanceof PertinentNegativeNull) {
            return null;
        }
        if (type != null && !type.isInstance(value)) {
            String msg = "Cached value is not of required type [" + type.getName() + "]: " + value;
            LOGGER.error(msg, (Throwable)new IllegalStateException(msg));
            return null;
        }
        LOGGER.info("Cache hit. Get by key {} and type {}  from cache {} value '{}'", new Object[]{key, type, this.cache.getName(), value});
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        if (!this.cache.isEnabled()) {
            LOGGER.warn("Cache {} is disabled. Cannot get {} from cache", (Object)this.cache.getName(), key);
            return this.loadValue(key, valueLoader);
        }
        Cache.ValueWrapper valueWrapper = this.get(key);
        if (valueWrapper != null) {
            return (T)valueWrapper.get();
        }
        String string = key.toString().intern();
        synchronized (string) {
            T value = this.loadValue(key, valueLoader);
            this.put(key, value);
            return value;
        }
    }

    public void put(Object key, Object value) {
        if (!this.cache.isEnabled()) {
            LOGGER.warn("Cache {} is disabled. Cannot put value under key {}", (Object)this.cache.getName(), key);
            return;
        }
        if (key != null) {
            String cacheKey = this.getKey(key);
            try {
                LOGGER.info("Put '{}' under key {} to cache {}", new Object[]{value, key, this.cache.getName()});
                Object store = this.toStoreValue(value);
                this.cache.set(cacheKey, this.expiration, store, null);
            }
            catch (CacheException | RuntimeException | TimeoutException e) {
                this.logOrThrow((Exception)e, "An error has ocurred for cache {} and key {}", this.getName(), cacheKey, e);
            }
        } else {
            LOGGER.info("Cannot put to cache {} because key is null", (Object)this.cache.getName());
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        if (!this.cache.isEnabled()) {
            LOGGER.warn("Cache {} is disabled. Cannot put value under key {}", (Object)this.cache.getName(), key);
            return null;
        }
        if (key != null) {
            String cacheKey = this.getKey(key);
            try {
                LOGGER.info("Put '{}' under key {} to cache {}", new Object[]{value, key, this.cache.getName()});
                Object store = this.toStoreValue(value);
                boolean added = this.cache.add(cacheKey, this.expiration, store, null);
                return added ? null : this.get(key);
            }
            catch (CacheException | RuntimeException | TimeoutException e) {
                this.logOrThrow((Exception)e, "An error has ocurred for cache {} and key {}", this.getName(), cacheKey, e);
            }
        } else {
            LOGGER.info("Cannot put to cache {} because key is null", (Object)this.cache.getName());
        }
        return null;
    }

    public void evict(Object key) {
        if (!this.cache.isEnabled()) {
            LOGGER.warn("Cache {} is disabled. Cannot evict key {}", (Object)this.cache.getName(), key);
            return;
        }
        if (key != null) {
            String cacheKey = this.getKey(key);
            try {
                LOGGER.info("Evict {} from cache {}", key, (Object)this.cache.getName());
                this.cache.delete(cacheKey);
            }
            catch (CacheException | RuntimeException | TimeoutException e) {
                this.logOrThrow((Exception)e, "An error has ocurred for cache {} and key {}", this.getName(), cacheKey, e);
            }
        } else {
            LOGGER.info("Cannot evict from cache {} because key is null", (Object)this.cache.getName());
        }
    }

    public void clear() {
        if (!this.cache.isEnabled()) {
            LOGGER.warn("Cache {} is disabled. Cannot clear cache.", (Object)this.cache.getName());
            return;
        }
        if (!this.allowClear) {
            LOGGER.error("Clearing cache '{}' is not allowed. To enable it set allowClear to true. Make sure that caches don't overlap (one memcached instance isn't used by more than one cache) otherwise clearing one cache will affect another.", (Object)this.getName());
            throw new IllegalStateException("Cannot clear cache " + this.getName());
        }
        try {
            LOGGER.info("Clear {}", (Object)this.cache.getName());
            this.cache.flush();
        }
        catch (CacheException | RuntimeException | TimeoutException e) {
            this.logOrThrow((Exception)e, "An error has ocurred for cache {}", this.getName(), e);
        }
    }

    private Object getValue(Object key) {
        String cacheKey = this.getKey(key);
        Object value = null;
        try {
            value = this.cache.get(cacheKey, null);
        }
        catch (CacheException | RuntimeException | TimeoutException e) {
            this.logOrThrow((Exception)e, "An error has ocurred for cache {} and key {}", this.getName(), cacheKey, e);
        }
        return value;
    }

    private String getKey(Object key) {
        return key.toString();
    }

    private <T> T loadValue(Object key, Callable<T> valueLoader) {
        try {
            return valueLoader.call();
        }
        catch (Exception ex) {
            throw new ValueRetrievalException(key, valueLoader, ex);
        }
    }

    private Object toStoreValue(Object value) {
        return value == null ? PertinentNegativeNull.NULL : value;
    }

    private void logOrThrow(RuntimeException e, String message, Object ... args) {
        LOGGER.warn(message, args);
        if (!this.muteExceptions) {
            throw e;
        }
    }

    private void logOrThrow(Exception e, String message, Object ... args) {
        if (RuntimeException.class.isInstance(e)) {
            this.logOrThrow((RuntimeException)RuntimeException.class.cast(e), message, args);
        } else {
            this.logOrThrow(new WrappedCacheException(e), message, args);
        }
    }

    public Cache getCache() {
        return this.cache;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public boolean isAllowClear() {
        return this.allowClear;
    }

    public boolean isMuteExceptions() {
        return this.muteExceptions;
    }

    public boolean isRegisterAliases() {
        return this.registerAliases;
    }

    public static class ValueRetrievalException
    extends RuntimeException {
        private static final long serialVersionUID = 7777933028628648800L;

        public ValueRetrievalException(Object key, Callable<?> loader, Throwable ex) {
            super(String.format("Value for key '%s' could not be loaded using '%s'", key, loader), ex);
        }
    }
}

