/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.providers.spymemcached;

import com.google.code.ssm.providers.AbstractMemcacheClientWrapper;
import com.google.code.ssm.providers.CacheException;
import com.google.code.ssm.providers.CacheTranscoder;
import com.google.code.ssm.providers.CachedObject;
import com.google.code.ssm.providers.CachedObjectImpl;
import com.google.code.ssm.providers.spymemcached.TranscoderAdapter;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.CachedData;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemcacheClientWrapper
extends AbstractMemcacheClientWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemcacheClientWrapper.class);
    private final Map<CacheTranscoder, Object> adapters = new HashMap<CacheTranscoder, Object>();
    private final MemcachedClientIF memcachedClient;

    MemcacheClientWrapper(MemcachedClientIF memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    public boolean add(String key, int exp, Object value) throws TimeoutException, CacheException {
        Future f = null;
        try {
            f = this.memcachedClient.add(key, exp, value);
            return (Boolean)f.get();
        }
        catch (InterruptedException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
    }

    public <T> boolean add(String key, int exp, T value, CacheTranscoder transcoder) throws TimeoutException, CacheException {
        Future f = null;
        try {
            f = this.memcachedClient.add(key, exp, value, this.getTranscoder(transcoder));
            return (Boolean)f.get();
        }
        catch (InterruptedException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
    }

    public long decr(String key, int by) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.decr(key, by);
        }
        catch (OperationTimeoutException e) {
            LOGGER.warn("Operation timeout while decr " + key, (Throwable)e);
            throw new TimeoutException(e.getMessage());
        }
        catch (RuntimeException e) {
            if (this.translateException(e)) {
                throw new CacheException((Throwable)e);
            }
            throw e;
        }
    }

    public long decr(String key, int by, long def) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.decr(key, by, def);
        }
        catch (OperationTimeoutException e) {
            LOGGER.warn("Operation timeout while decr " + key, (Throwable)e);
            throw new TimeoutException(e.getMessage());
        }
        catch (RuntimeException e) {
            if (this.translateException(e)) {
                throw new CacheException((Throwable)e);
            }
            throw e;
        }
    }

    public boolean delete(String key) throws TimeoutException, CacheException {
        try {
            return (Boolean)this.memcachedClient.delete(key).get();
        }
        catch (InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void flush() throws CacheException {
        try {
            this.memcachedClient.flush().get();
        }
        catch (InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public Object get(String key) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.get(key);
        }
        catch (RuntimeException e) {
            if (this.translateException(e)) {
                throw new CacheException((Throwable)e);
            }
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            throw e;
        }
    }

    public <T> T get(String key, CacheTranscoder transcoder) throws CacheException, TimeoutException {
        try {
            return (T)this.memcachedClient.get(key, this.getTranscoder(transcoder));
        }
        catch (RuntimeException e) {
            if (this.translateException(e)) {
                throw new CacheException((Throwable)e);
            }
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            throw e;
        }
    }

    public <T> T get(String key, CacheTranscoder transcoder, long timeout) throws TimeoutException, CacheException {
        Future f = null;
        try {
            f = this.memcachedClient.asyncGet(key, this.getTranscoder(transcoder));
            return (T)f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
    }

    public Collection<SocketAddress> getAvailableServers() {
        return this.memcachedClient.getAvailableServers();
    }

    public Map<String, Object> getBulk(Collection<String> keys) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.getBulk(keys);
        }
        catch (OperationTimeoutException e) {
            throw (TimeoutException)e.getCause();
        }
        catch (RuntimeException e) {
            if (this.translateException(e)) {
                throw new CacheException((Throwable)e);
            }
            throw e;
        }
    }

    public <T> Map<String, T> getBulk(Collection<String> keys, CacheTranscoder transcoder) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.getBulk(keys, this.getTranscoder(transcoder));
        }
        catch (OperationTimeoutException e) {
            throw (TimeoutException)e.getCause();
        }
        catch (RuntimeException e) {
            if (this.translateException(e)) {
                throw new CacheException((Throwable)e);
            }
            throw e;
        }
    }

    public long incr(String key, int by) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.incr(key, by);
        }
        catch (OperationTimeoutException e) {
            LOGGER.warn("Operation timeout while incr " + key, (Throwable)e);
            throw new TimeoutException(e.getMessage());
        }
        catch (RuntimeException e) {
            if (this.translateException(e)) {
                throw new CacheException((Throwable)e);
            }
            throw e;
        }
    }

    public long incr(String key, int by, long def) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.incr(key, by, def);
        }
        catch (OperationTimeoutException e) {
            LOGGER.warn("Operation timeout while incr " + key, (Throwable)e);
            throw new TimeoutException(e.getMessage());
        }
        catch (RuntimeException e) {
            if (this.translateException(e)) {
                throw new CacheException((Throwable)e);
            }
            throw e;
        }
    }

    public long incr(String key, int by, long def, int expiration) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.incr(key, by, def, expiration);
        }
        catch (OperationTimeoutException e) {
            LOGGER.warn("Operation timeout while incr " + key, (Throwable)e);
            throw new TimeoutException(e.getMessage());
        }
        catch (RuntimeException e) {
            if (this.translateException(e)) {
                throw new CacheException((Throwable)e);
            }
            throw e;
        }
    }

    public boolean set(String key, int exp, Object value) throws TimeoutException, CacheException {
        Future f = null;
        try {
            f = this.memcachedClient.set(key, exp, value);
            return (Boolean)f.get();
        }
        catch (InterruptedException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
    }

    public <T> boolean set(String key, int exp, T value, CacheTranscoder transcoder) throws TimeoutException, CacheException {
        Future f = null;
        try {
            f = this.memcachedClient.set(key, exp, value, this.getTranscoder(transcoder));
            return (Boolean)f.get();
        }
        catch (InterruptedException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            this.cancel(f);
            throw new CacheException((Throwable)e);
        }
    }

    public void shutdown() {
        this.memcachedClient.shutdown();
    }

    public CacheTranscoder getTranscoder() {
        return new TranscoderWrapper((Transcoder<Object>)this.memcachedClient.getTranscoder());
    }

    private <T> Transcoder<T> getTranscoder(CacheTranscoder transcoder) {
        Transcoder transcoderAdapter = (Transcoder)this.adapters.get(transcoder);
        if (transcoderAdapter == null) {
            transcoderAdapter = new TranscoderAdapter(transcoder);
            this.adapters.put(transcoder, transcoderAdapter);
        }
        return transcoderAdapter;
    }

    private void cancel(Future<?> f) {
        if (f != null) {
            f.cancel(true);
        }
    }

    private boolean translateException(RuntimeException e) {
        return e.getCause() instanceof InterruptedException || e.getCause() instanceof ExecutionException;
    }

    private static class TranscoderWrapper
    implements CacheTranscoder {
        private final Transcoder<Object> transcoder;

        public TranscoderWrapper(Transcoder<Object> transcoder) {
            this.transcoder = transcoder;
        }

        public Object decode(CachedObject data) {
            return this.transcoder.decode(new CachedData(data.getFlags(), data.getData(), 0x100000));
        }

        public CachedObject encode(Object o) {
            CachedData cachedData = this.transcoder.encode(o);
            return new CachedObjectImpl(cachedData.getFlags(), cachedData.getData());
        }
    }
}

