/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.providers.xmemcached;

import com.google.code.ssm.providers.CacheClient;
import com.google.code.ssm.providers.CacheClientFactory;
import com.google.code.ssm.providers.CacheConfiguration;
import com.google.code.ssm.providers.xmemcached.MemcacheClientWrapper;
import com.google.code.ssm.providers.xmemcached.ReconnectListener;
import com.google.code.ssm.providers.xmemcached.XMemcachedConfiguration;
import com.google.code.yanf4j.core.SocketOption;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;

public class MemcacheClientFactoryImpl
implements CacheClientFactory {
    public CacheClient create(List<InetSocketAddress> addrs, CacheConfiguration conf) throws IOException {
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(addrs);
        if (conf.isConsistentHashing()) {
            builder.setSessionLocator((MemcachedSessionLocator)new KetamaMemcachedSessionLocator());
        }
        if (conf.isUseBinaryProtocol()) {
            builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        }
        if (conf instanceof XMemcachedConfiguration) {
            this.setProviderBuilderSpecificSettings((MemcachedClientBuilder)builder, (XMemcachedConfiguration)conf);
        }
        MemcachedClient client = builder.build();
        if (conf.getOperationTimeout() != null) {
            client.setOpTimeout((long)conf.getOperationTimeout().intValue());
        }
        if (conf instanceof XMemcachedConfiguration) {
            this.setProviderClientSpecificSettings(client, (XMemcachedConfiguration)conf);
        }
        return new MemcacheClientWrapper(client);
    }

    private void setProviderBuilderSpecificSettings(MemcachedClientBuilder builder, XMemcachedConfiguration conf) {
        if (conf.getConnectionPoolSize() != null) {
            builder.setConnectionPoolSize(conf.getConnectionPoolSize().intValue());
        }
        if (conf.getConfiguration() != null) {
            builder.setConfiguration(conf.getConfiguration());
        }
        if (conf.getFailureMode() != null) {
            builder.setFailureMode(conf.getFailureMode().booleanValue());
        }
        if (conf.getSocketOptions() != null) {
            for (Map.Entry<SocketOption<?>, Object> entry : conf.getSocketOptions().entrySet()) {
                builder.setSocketOption(entry.getKey(), entry.getValue());
            }
        }
        if (conf.getDefaultTranscoder() != null) {
            builder.setTranscoder(conf.getDefaultTranscoder());
        }
    }

    private void setProviderClientSpecificSettings(MemcachedClient client, XMemcachedConfiguration conf) {
        if (conf.getMaxAwayTime() != null) {
            client.addStateListener((MemcachedClientStateListener)new ReconnectListener(conf.getMaxAwayTime()));
        }
        if (conf.getEnableHeartBeat() != null) {
            client.setEnableHeartBeat(conf.getEnableHeartBeat().booleanValue());
        }
        if (conf.getHealSessionInterval() != null) {
            client.setHealSessionInterval(conf.getHealSessionInterval().longValue());
        }
        if (conf.getMergeFactor() != null) {
            client.setMergeFactor(conf.getMergeFactor().intValue());
        }
        if (conf.getOptimizeGet() != null) {
            client.setOptimizeGet(conf.getOptimizeGet().booleanValue());
        }
        if (conf.getOptimizeMergeBuffer() != null) {
            client.setOptimizeMergeBuffer(conf.getOptimizeMergeBuffer().booleanValue());
        }
        if (conf.getPrimitiveAsString() != null) {
            client.setPrimitiveAsString(conf.getPrimitiveAsString().booleanValue());
        }
        if (conf.getSanitizeKeys() != null) {
            client.setSanitizeKeys(conf.getSanitizeKeys().booleanValue());
        }
    }
}

