/*
 * Decompiled with CFR 0.152.
 */
package org.svenson;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.svenson.DynamicProperties;
import org.svenson.JSONCharacterSink;
import org.svenson.JSONProperty;
import org.svenson.JSONReference;
import org.svenson.JSONable;
import org.svenson.JSONifier;
import org.svenson.SinkAwareJSONifier;
import org.svenson.StringBuilderSink;
import org.svenson.WriterSink;
import org.svenson.converter.TypeConverter;
import org.svenson.converter.TypeConverterRepository;
import org.svenson.util.ExceptionWrapper;
import org.svenson.util.JSONBeanUtil;
import org.svenson.util.TypeConverterCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSON {
    private static final JSON defaultJSON = new JSON();
    private Map<Class, JSONifier> jsonifiers = Collections.synchronizedMap(new HashMap());
    private char quoteChar;
    private boolean escapeUnicodeChars = true;
    private TypeConverterCache typeConverterCache;
    private Collection<String> ignoredProperties;
    private Map<Class, TypeConverter> typeConvertersByClass;
    private static final String INDENT = "  ";
    private static final String NEWLINE = System.getProperty("line.separator");

    public static JSON defaultJSON() {
        return defaultJSON;
    }

    public JSON() {
        this('\"');
    }

    public JSON(char quoteChar) {
        this.setQuoteChar(quoteChar);
    }

    public void setEscapeUnicodeChars(boolean escapeUnicodeChars) {
        this.escapeUnicodeChars = escapeUnicodeChars;
    }

    public boolean isEscapeUnicodeChars() {
        return this.escapeUnicodeChars;
    }

    public void setTypeConverterRepository(TypeConverterRepository typeConverterRepository) {
        this.typeConverterCache = new TypeConverterCache(typeConverterRepository);
    }

    public void registerJSONifier(Class c, JSONifier jsonifier) {
        this.jsonifiers.put(c, jsonifier);
    }

    public void deregisterJSONifiers() {
        this.jsonifiers.clear();
    }

    public void registerTypeConversion(Class<?> cls, TypeConverter converter) {
        if (this.typeConvertersByClass == null) {
            this.typeConvertersByClass = new HashMap<Class, TypeConverter>();
        }
        this.typeConvertersByClass.put(cls, converter);
    }

    public void setIgnoredProperties(Collection<String> ignoredProperties) {
        this.ignoredProperties = ignoredProperties;
    }

    public Collection<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public String dumpObjectFormatted(Object o) {
        StringBuilderSink out = new StringBuilderSink();
        this.dumpObject(out, o);
        return JSON.formatJSON(out.getContent());
    }

    public static String formatJSON(String s) {
        StringBuilder sb = new StringBuilder(s.length() * 3 / 2);
        StringTokenizer st = new StringTokenizer(s, "{}[],\"", true);
        int icnt = 0;
        String lastToken = "";
        boolean quoted = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\"")) {
                int pos = lastToken.length() - 1;
                int cnt = 0;
                while (pos >= 0 && lastToken.charAt(pos) == '\\') {
                    --pos;
                    ++cnt;
                }
                if (!(cnt & true)) {
                    boolean bl = quoted = !quoted;
                }
            }
            if (quoted) {
                sb.append(token);
            } else if (token.equals("{") || token.equals("[")) {
                sb.append(token);
                JSON.newLine(sb, ++icnt);
            } else if (token.equals("}") || token.equals("]")) {
                JSON.newLine(sb, --icnt);
                sb.append(token);
            } else if (token.equals(",")) {
                sb.append(token);
                JSON.newLine(sb, icnt);
            } else {
                sb.append(token);
            }
            lastToken = token;
        }
        return sb.toString();
    }

    private static void newLine(StringBuilder sb, int cnt) {
        sb.append(NEWLINE);
        for (int i = 0; i < cnt; ++i) {
            sb.append(INDENT);
        }
    }

    public void dumpObject(JSONCharacterSink out, Object o) {
        this.dumpObject(out, o, '\u0000', this.ignoredProperties);
    }

    public void dumpObject(JSONCharacterSink out, Object o, Collection<String> ignoredProps) {
        this.dumpObject(out, o, '\u0000', ignoredProps);
    }

    /*
     * WARNING - void declaration
     */
    private void dumpObject(JSONCharacterSink out, Object o, char separator, Collection<String> ignoredProps) {
        if (o == null) {
            out.append("null");
        } else {
            Class<?> oClass = o.getClass();
            TypeConverter typeConverterFromClass = null;
            if (oClass.isPrimitive()) {
                out.append(o);
            } else if (Number.class.isAssignableFrom(oClass) || oClass.equals(Boolean.class) || oClass.equals(Character.class)) {
                out.append(o);
            } else if (o instanceof String) {
                this.quote(out, (String)o);
            } else if (o instanceof Collection) {
                out.append('[');
                Iterator i = ((Collection)o).iterator();
                while (i.hasNext()) {
                    this.dumpObject(out, i.next(), i.hasNext() ? (char)',' : '\u0000', ignoredProps);
                }
                out.append(']');
            } else if (o.getClass().isArray()) {
                out.append('[');
                int len = Array.getLength(o);
                for (int i = 0; i < len; ++i) {
                    this.dumpObject(out, Array.get(o, i), i < len - 1 ? (char)',' : '\u0000', ignoredProps);
                }
                out.append(']');
            } else if (o instanceof Map) {
                out.append('{');
                Map m = (Map)o;
                Iterator i = m.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    this.dumpObject(out, key.toString(), '\u0000', ignoredProps);
                    out.append(':');
                    this.dumpObject(out, m.get(key), i.hasNext() ? (char)',' : '\u0000', ignoredProps);
                }
                out.append('}');
            } else {
                JSONifier jsonifier = this.getJSONifierForClass(oClass);
                if (jsonifier != null) {
                    if (jsonifier instanceof SinkAwareJSONifier) {
                        ((SinkAwareJSONifier)jsonifier).writeToSink(out, o);
                    } else {
                        out.append(jsonifier.toJSON(o));
                    }
                } else if (o instanceof JSONable) {
                    out.append(((JSONable)o).toJSON());
                } else if (o instanceof Class) {
                    this.quote(out, ((Class)o).getName());
                } else if (o instanceof Enum) {
                    this.quote(out, ((Enum)o).name());
                } else if (this.typeConvertersByClass != null && (typeConverterFromClass = this.typeConvertersByClass.get(o.getClass())) != null) {
                    Object value = typeConverterFromClass.toJSON(o);
                    this.dumpObject(out, value, '\u0000', ignoredProps);
                } else {
                    BeanInfo info;
                    try {
                        info = Introspector.getBeanInfo(o.getClass());
                    }
                    catch (IntrospectionException e) {
                        throw ExceptionWrapper.wrap(e);
                    }
                    out.append('{');
                    boolean first = true;
                    PropertyDescriptor[] pds = info.getPropertyDescriptors();
                    for (int cp = 0; cp < pds.length; ++cp) {
                        try {
                            JSONReference jSONReference;
                            TypeConverter typeConverter;
                            boolean ignore;
                            PropertyDescriptor pd = pds[cp];
                            Method method = pd.getReadMethod();
                            Method writeMethod = pd.getWriteMethod();
                            if (method == null) continue;
                            String name = pd.getName();
                            boolean bl = ignore = ignoredProps != null && ignoredProps.contains(name);
                            if (name.equals("class") || ignore) continue;
                            JSONProperty jsonProperty = method.getAnnotation(JSONProperty.class);
                            if (jsonProperty == null && writeMethod != null) {
                                jsonProperty = writeMethod.getAnnotation(JSONProperty.class);
                            }
                            if (jsonProperty != null) {
                                String nameFromAnnotation = jsonProperty.value();
                                if (nameFromAnnotation.length() > 0) {
                                    name = jsonProperty.value();
                                }
                                ignore = jsonProperty.ignore();
                            }
                            Cloneable value = null;
                            if (!ignore) {
                                value = method.invoke(o, (Object[])null);
                            }
                            if (value == null && jsonProperty != null && jsonProperty.ignoreIfNull()) {
                                ignore = true;
                            }
                            if (ignore) continue;
                            if (this.typeConverterCache != null && (typeConverter = this.typeConverterCache.getTypeConverter(o, pd.getName())) != null) {
                                value = typeConverter.toJSON(value);
                            }
                            if ((jSONReference = method.getAnnotation(JSONReference.class)) == null && writeMethod != null) {
                                jSONReference = writeMethod.getAnnotation(JSONReference.class);
                            }
                            if (jSONReference != null) {
                                ArrayList<Object> newList;
                                String idProperty = jSONReference.idProperty();
                                if (value instanceof Collection) {
                                    newList = new ArrayList<Object>();
                                    for (Object e : (Collection)((Object)value)) {
                                        newList.add(JSONBeanUtil.getProperty(e, idProperty));
                                    }
                                    value = newList;
                                } else if (value.getClass().isArray()) {
                                    void var23_37;
                                    newList = new ArrayList();
                                    int len = Array.getLength(value);
                                    boolean bl2 = false;
                                    while (var23_37 < len) {
                                        newList.add(JSONBeanUtil.getProperty(Array.get(value, (int)var23_37), idProperty));
                                        ++var23_37;
                                    }
                                    value = newList;
                                } else if (value instanceof Map) {
                                    HashMap newMap = new HashMap();
                                    for (Map.Entry entry : ((Map)((Object)value)).entrySet()) {
                                        newMap.put(entry.getKey(), JSONBeanUtil.getProperty(entry.getValue(), idProperty));
                                    }
                                    value = newMap;
                                } else {
                                    value = JSONBeanUtil.getProperty(value, idProperty);
                                }
                            }
                            if (!first) {
                                out.append(',');
                            }
                            this.quote(out, name);
                            out.append(':');
                            this.dumpObject(out, value, '\u0000', ignoredProps);
                            first = false;
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw ExceptionWrapper.wrap(e);
                        }
                        catch (InvocationTargetException e) {
                            throw ExceptionWrapper.wrap(e);
                        }
                    }
                    if (o instanceof DynamicProperties) {
                        DynamicProperties dynAttrs = (DynamicProperties)o;
                        for (String name : dynAttrs.propertyNames()) {
                            if (!first) {
                                out.append(',');
                            }
                            first = false;
                            this.quote(out, name);
                            out.append(':');
                            this.dumpObject(out, dynAttrs.getProperty(name), '\u0000', ignoredProps);
                        }
                    }
                    out.append('}');
                }
            }
        }
        if (separator != '\u0000') {
            out.append(separator);
        }
    }

    private JSONifier getJSONifierForClass(Class oClass) {
        for (Map.Entry<Class, JSONifier> e : this.jsonifiers.entrySet()) {
            if (!e.getKey().isAssignableFrom(oClass)) continue;
            return e.getValue();
        }
        return null;
    }

    public String forValue(Object o) {
        StringBuilderSink tmp = new StringBuilderSink();
        this.dumpObject(tmp, o);
        return tmp.getContent();
    }

    public void writeJSONToWriter(Object o, Writer w) {
        this.dumpObject(new WriterSink(w), o);
    }

    public String forValue(Object o, Collection<String> ignoredProps) {
        StringBuilderSink tmp = new StringBuilderSink();
        this.dumpObject(tmp, o, ignoredProps);
        return tmp.getContent();
    }

    public void quote(JSONCharacterSink buf, String s) {
        if (s == null) {
            buf.append("null");
            return;
        }
        buf.append(this.quoteChar);
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (c == this.quoteChar) {
                        buf.append("\\" + c);
                        continue block10;
                    }
                    buf.append(c);
                    continue block10;
                }
                case '/': {
                    buf.append("\\/");
                    continue block10;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block10;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block10;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block10;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block10;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block10;
                }
                default: {
                    if (c < ' ' || c > '~' && this.escapeUnicodeChars) {
                        String h = Integer.toHexString(c);
                        int len = h.length();
                        if (len < 4) {
                            h = "0000".substring(len) + h;
                        }
                        buf.append("\\u" + h);
                        continue block10;
                    }
                    buf.append(c);
                }
            }
        }
        buf.append(this.quoteChar);
    }

    public String quote(String s) {
        StringBuilderSink sb = new StringBuilderSink();
        this.quote(sb, s);
        return sb.getContent();
    }

    public void setQuoteChar(char c) {
        if (c != '\"' && c != '\'') {
            throw new IllegalArgumentException("quote char must be ' or \"");
        }
        this.quoteChar = c;
    }
}

