/*
 * Decompiled with CFR 0.152.
 */
package org.svenson;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.svenson.DynamicProperties;
import org.svenson.JSONParseException;
import org.svenson.JSONProperty;
import org.svenson.JSONReference;
import org.svenson.JSONTypeHint;
import org.svenson.ObjectFactory;
import org.svenson.TypeMapper;
import org.svenson.converter.TypeConverter;
import org.svenson.converter.TypeConverterRepository;
import org.svenson.matcher.EqualsPathMatcher;
import org.svenson.matcher.PathMatcher;
import org.svenson.tokenize.JSONCharacterSource;
import org.svenson.tokenize.JSONTokenizer;
import org.svenson.tokenize.Token;
import org.svenson.tokenize.TokenType;
import org.svenson.util.ExceptionWrapper;
import org.svenson.util.TypeConverterCache;
import org.svenson.util.ValueHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONParser {
    protected static Logger log = LoggerFactory.getLogger(JSONParser.class);
    private static ConcurrentMap<Class, ValueHolder<Map<String, Method>>> classToAddMethods = new ConcurrentHashMap<Class, ValueHolder<Map<String, Method>>>();
    private static ConcurrentMap<Class, ValueHolder<Map<String, Class>>> classToTypeHintFromAnnotation = new ConcurrentHashMap<Class, ValueHolder<Map<String, Class>>>();
    private static final JSONParser defaultJSONParser = new JSONParser();
    private Map<PathMatcher, Class> typeHints = new HashMap<PathMatcher, Class>();
    private TypeMapper typeMapper;
    private Map<Class, Class> interfaceMappings;
    private List<ObjectFactory> objectFactories = new ArrayList<ObjectFactory>();
    private boolean allowSingleQuotes;
    private TypeConverterCache typeConverterCache;
    private Map<Class, TypeConverter> typeConvertersByClass;

    public JSONParser() {
        this.interfaceMappings = new HashMap<Class, Class>();
        this.interfaceMappings.put(Collection.class, ArrayList.class);
        this.interfaceMappings.put(Set.class, HashSet.class);
        this.interfaceMappings.put(List.class, ArrayList.class);
        this.interfaceMappings.put(Map.class, HashMap.class);
    }

    public JSONParser(JSONParser src) {
        this();
        if (src != null) {
            this.typeHints = new HashMap<PathMatcher, Class>(src.typeHints);
            this.typeMapper = src.typeMapper;
            this.interfaceMappings = new HashMap<Class, Class>(src.interfaceMappings);
            this.objectFactories = new ArrayList<ObjectFactory>(src.objectFactories);
            this.allowSingleQuotes = src.allowSingleQuotes;
            this.typeConverterCache = src.typeConverterCache;
            if (src.typeConvertersByClass != null) {
                this.typeConvertersByClass = new HashMap<Class, TypeConverter>(src.typeConvertersByClass);
            }
        }
    }

    public static JSONParser defaultJSONParser() {
        return defaultJSONParser;
    }

    public void setTypeMapper(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public void registerTypeConversion(Class cls, TypeConverter converter) {
        if (this.typeConvertersByClass == null) {
            this.typeConvertersByClass = new HashMap<Class, TypeConverter>();
        }
        this.typeConvertersByClass.put(cls, converter);
    }

    public void setTypeHints(Map<String, Class> typeHints) {
        this.typeHints = new HashMap<PathMatcher, Class>();
        for (Map.Entry<String, Class> e : typeHints.entrySet()) {
            this.typeHints.put(new EqualsPathMatcher(e.getKey()), e.getValue());
        }
    }

    public void setInterfaceMappings(Map<Class, Class> interfaceMappings) {
        for (Map.Entry<Class, Class> e : interfaceMappings.entrySet()) {
            Class iface = e.getKey();
            Class cls = e.getValue();
            if (!iface.isInterface()) {
                throw new IllegalArgumentException("The key " + iface + " must be an interface that is mapped to a class type.");
            }
            if (cls.isInterface()) {
                throw new IllegalArgumentException("The value " + cls + " must be a class type.");
            }
            if (iface.isAssignableFrom(cls)) continue;
            throw new IllegalArgumentException("The class " + cls + " does not implement the interface " + iface);
        }
        this.interfaceMappings = interfaceMappings;
    }

    public void addObjectFactory(ObjectFactory objectFactory) {
        if (objectFactory == null) {
            throw new IllegalArgumentException("objectFactory can't be null");
        }
        this.objectFactories.add(objectFactory);
    }

    public void addTypeHint(String key, Class typeHint) {
        this.typeHints.put(new EqualsPathMatcher(key), typeHint);
    }

    public void addTypeHint(PathMatcher pathMatcher, Class typeHint) {
        this.typeHints.put(pathMatcher, typeHint);
    }

    public void setTypeConverterRepository(TypeConverterRepository typeConverterRepository) {
        this.typeConverterCache = new TypeConverterCache(typeConverterRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object parse(String json) {
        JSONTokenizer tokenizer = new JSONTokenizer(json, this.allowSingleQuotes);
        try {
            Object object = this.parse(tokenizer);
            return object;
        }
        finally {
            tokenizer.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object parse(JSONCharacterSource source) {
        JSONTokenizer tokenizer = new JSONTokenizer(source, this.allowSingleQuotes);
        try {
            Object object = this.parse(tokenizer);
            return object;
        }
        finally {
            tokenizer.destroy();
        }
    }

    private Object parse(JSONTokenizer tokenizer) {
        Token token = tokenizer.peekToken();
        if (token.isType(TokenType.BRACKET_OPEN)) {
            return this.parse(ArrayList.class, tokenizer);
        }
        if (token.isType(TokenType.BRACE_OPEN)) {
            Class typeHint = this.getTypeHint("", tokenizer, null, true);
            if (typeHint != null) {
                return this.parse(typeHint, tokenizer);
            }
            return this.parse(HashMap.class, tokenizer);
        }
        if (token.isType(TokenType.NULL) || token.isType(TokenType.FALSE) || token.isType(TokenType.TRUE) || token.isType(TokenType.INTEGER) || token.isType(TokenType.DECIMAL) || token.isType(TokenType.STRING)) {
            return token.value();
        }
        throw new JSONParseException("Invalid start token " + token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Class<T> targetType, String json) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type cannot be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json string cannot be null");
        }
        JSONTokenizer tokenizer = new JSONTokenizer(json, this.allowSingleQuotes);
        try {
            T t = this.parse(targetType, tokenizer);
            return t;
        }
        finally {
            tokenizer.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Class<T> targetType, JSONCharacterSource source) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type cannot be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("character source cannot be null");
        }
        JSONTokenizer tokenizer = new JSONTokenizer(source, this.allowSingleQuotes);
        try {
            T t = this.parse(targetType, tokenizer);
            return t;
        }
        finally {
            tokenizer.destroy();
        }
    }

    private <T> T parse(Class<T> targetType, JSONTokenizer tokenizer) {
        try {
            Object t;
            Token token = tokenizer.next();
            TokenType type = token.type();
            if (type == TokenType.BRACE_OPEN) {
                Class typeHint = this.getTypeHint("", tokenizer, targetType, true);
                if (typeHint != null) {
                    targetType = typeHint;
                }
                t = this.createNewTargetInstance(targetType, true);
                this.parseObjectInto(new ParseContext(t, null), tokenizer);
            } else if (type == TokenType.BRACKET_OPEN) {
                t = this.createNewTargetInstance(targetType, false);
                this.parseArrayInto(new ParseContext(t, null), tokenizer);
            } else {
                if (type == TokenType.STRING && Enum.class.isAssignableFrom(targetType)) {
                    return Enum.valueOf(targetType, (String)token.value());
                }
                throw new JSONParseException("unexpected token " + token);
            }
            return (T)t;
        }
        catch (InstantiationException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionWrapper.wrap(e);
        }
    }

    public void setAllowSingleQuotes(boolean allowSingleQuotes) {
        this.allowSingleQuotes = allowSingleQuotes;
    }

    private void parseArrayInto(ParseContext cx, JSONTokenizer tokenizer) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Token valueToken;
        TokenType valueType;
        boolean containerIsCollection = Collection.class.isAssignableFrom(cx.target.getClass());
        boolean first = true;
        while ((valueType = (valueToken = tokenizer.next()).type()) != TokenType.BRACKET_CLOSE) {
            Object value;
            if (!first) {
                valueToken.expect(TokenType.COMMA);
                valueToken = tokenizer.next();
                valueType = valueToken.type();
            }
            Class typeHint = this.getTypeHint(cx, cx.getParsePathInfo("[]"), tokenizer, "[]", false, valueType.isPrimitive());
            if (valueType.isPrimitive()) {
                value = valueToken.value();
                if (typeHint != null) {
                    value = this.convertValueTo(value, typeHint);
                }
            } else {
                Object newTarget = null;
                if (valueType == TokenType.BRACE_OPEN) {
                    newTarget = this.createNewTargetInstance(typeHint, true);
                    this.parseObjectInto(cx.push(newTarget, null, "[]"), tokenizer);
                } else if (valueType == TokenType.BRACKET_OPEN) {
                    newTarget = this.createNewTargetInstance(typeHint, false);
                    this.parseArrayInto(cx.push(newTarget, null, "[]"), tokenizer);
                } else {
                    throw new JSONParseException("Unexpected token " + valueToken);
                }
                value = newTarget;
            }
            if (!containerIsCollection) {
                throw new JSONParseException("Cannot add value " + value + " to " + cx.target + " ( " + cx.target.getClass() + " )");
            }
            ((Collection)cx.target).add(value);
            first = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseObjectInto(ParseContext cx, JSONTokenizer tokenizer) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Token key;
        boolean containerIsMap = Map.class.isAssignableFrom(cx.target.getClass());
        boolean containerIsDynAttrs = cx.target instanceof DynamicProperties;
        boolean first = true;
        while ((key = first ? tokenizer.expectNext(TokenType.STRING, TokenType.BRACE_CLOSE) : tokenizer.expectNext(TokenType.COMMA, TokenType.BRACE_CLOSE)).type() != TokenType.BRACE_CLOSE) {
            Object value;
            String jsonName;
            if (!first) {
                key = tokenizer.expectNext(TokenType.STRING);
            }
            if ((jsonName = (String)key.value()).length() == 0) {
                throw new JSONParseException("Invalid empty property name");
            }
            String name = null;
            tokenizer.expectNext(TokenType.COLON);
            Token valueToken = tokenizer.next();
            TokenType valueType = valueToken.type();
            boolean isProperty = false;
            boolean isIgnoredOnParse = false;
            Method addMethod = null;
            if (!containerIsMap) {
                name = JSONParser.getPropertyNameFromAnnotation(cx.target, jsonName);
                isProperty = false;
                isIgnoredOnParse = false;
                if (name != null) {
                    boolean writeable = PropertyUtils.isWriteable((Object)cx.target, (String)name);
                    boolean bl = isIgnoredOnParse = !writeable && this.isReadOnlyProperty(cx.target, name);
                    if (this.isLinkedProperty(cx.target, name)) {
                        isIgnoredOnParse = true;
                    }
                    isProperty = writeable || isIgnoredOnParse;
                }
                addMethod = this.getAddMethod(cx.target, jsonName);
            }
            TypeConverter typeConverter = null;
            if (this.typeConverterCache != null) {
                typeConverter = this.typeConverterCache.getTypeConverter(cx.target, name);
            }
            if (!(isProperty || containerIsMap || containerIsDynAttrs || addMethod != null)) {
                throw new JSONParseException("Cannot set property " + jsonName + " on " + cx.target.getClass());
            }
            if (name == null) {
                name = jsonName;
            }
            Class<List> typeHint = this.getTypeHint(cx, cx.getParsePathInfo(jsonName), tokenizer, name, isProperty, valueType.isPrimitive());
            if (valueType.isPrimitive()) {
                value = valueToken.value();
            } else {
                Class<?> memberType;
                Object newTarget = null;
                if (valueType == TokenType.BRACE_OPEN) {
                    memberType = null;
                    if (isProperty) {
                        memberType = this.getTypeHintFromAnnotation(cx, name);
                    }
                    newTarget = this.createNewTargetInstance(typeHint, true);
                    this.parseObjectInto(cx.push(newTarget, memberType, "." + name), tokenizer);
                } else {
                    if (valueType != TokenType.BRACKET_OPEN) throw new JSONParseException("Unexpected token " + valueToken);
                    if (isProperty || containerIsMap || containerIsDynAttrs) {
                        Class<List> arrayTypeHint = typeHint;
                        if (isProperty && this.typeConverterCache != null && typeConverter != null && !List.class.isAssignableFrom(arrayTypeHint)) {
                            arrayTypeHint = List.class;
                        }
                        newTarget = this.createNewTargetInstance(arrayTypeHint, false);
                        Class memberType2 = this.getTypeHintFromAnnotation(cx, name);
                        this.parseArrayInto(cx.push(newTarget, memberType2, "." + name), tokenizer);
                    } else {
                        if (addMethod == null) throw new JSONParseException("Cannot set array to property " + name + " on " + cx.target);
                        memberType = addMethod.getParameterTypes()[0];
                        ArrayList temp = new ArrayList();
                        this.parseArrayInto(cx.push(temp, memberType, "." + name), tokenizer);
                        for (Object o : temp) {
                            addMethod.invoke(cx.target, o);
                        }
                        continue;
                    }
                }
                value = newTarget;
            }
            if (typeConverter != null && !isIgnoredOnParse) {
                value = typeConverter.fromJSON(value);
            }
            if (typeHint != null && !isIgnoredOnParse) {
                value = this.convertValueTo(value, typeHint);
            }
            if (isProperty) {
                if (!isIgnoredOnParse) {
                    try {
                        Class targetClass = PropertyUtils.getPropertyType((Object)cx.target, (String)name);
                        PropertyUtils.setProperty((Object)cx.target, (String)name, (Object)value);
                    }
                    catch (IllegalAccessException e) {
                        throw ExceptionWrapper.wrap(e);
                    }
                    catch (InvocationTargetException e) {
                        throw ExceptionWrapper.wrap(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw ExceptionWrapper.wrap(e);
                    }
                }
            } else if (containerIsMap) {
                ((Map)cx.target).put(name, value);
            } else {
                if (!containerIsDynAttrs) throw new JSONParseException("Cannot set property " + name + " on " + cx.target);
                ((DynamicProperties)cx.target).setProperty(name, value);
            }
            first = false;
        }
    }

    private boolean isLinkedProperty(Object target, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)target, (String)name);
        JSONReference jSONReferenceAnno = desc.getReadMethod().getAnnotation(JSONReference.class);
        Method writeMethod = desc.getWriteMethod();
        if (jSONReferenceAnno == null && writeMethod != null) {
            jSONReferenceAnno = writeMethod.getAnnotation(JSONReference.class);
        }
        return jSONReferenceAnno != null;
    }

    private boolean isReadOnlyProperty(Object target, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)target, (String)name);
        JSONProperty anno = desc.getReadMethod().getAnnotation(JSONProperty.class);
        return anno != null && anno.readOnly();
    }

    private Class getReplacementForKnownInterface(Class type) {
        if (type != null && type.isInterface()) {
            int leastTypeDistance = Integer.MAX_VALUE;
            Class best = null;
            for (Map.Entry<Class, Class> e : this.interfaceMappings.entrySet()) {
                Class curInterface = e.getKey();
                if (!type.isAssignableFrom(curInterface)) continue;
                if (type.getName().equals(curInterface.getName())) {
                    return e.getValue();
                }
                int distance = JSONParser.getTypeDistance(type, curInterface, 1);
                if (distance >= leastTypeDistance) continue;
                leastTypeDistance = distance;
                best = curInterface;
            }
            if (best == null) {
                throw new IllegalArgumentException("No Mapping found for " + type + ". cannot instantiate interfaces ");
            }
            return best;
        }
        return null;
    }

    static Integer getTypeDistance(Class type, Class ifaceClass, int dist) {
        for (Class<?> cls : ifaceClass.getInterfaces()) {
            if (type.getName().equals(cls.getName())) {
                return dist;
            }
            Integer d2 = JSONParser.getTypeDistance(type, cls, dist + 1);
            if (d2 == null) continue;
            return d2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getAddMethod(Object bean, String name) {
        HashMap<String, Method> addMethods;
        ValueHolder holder = new ValueHolder();
        Class<?> cls = bean.getClass();
        ValueHolder existing = classToAddMethods.putIfAbsent(cls, holder);
        if (existing != null) {
            holder = existing;
        }
        if ((addMethods = (HashMap<String, Method>)holder.getValue()) == null) {
            ValueHolder valueHolder = holder;
            synchronized (valueHolder) {
                addMethods = (Map)holder.getValue();
                if (addMethods == null) {
                    addMethods = new HashMap<String, Method>();
                    for (Method m : cls.getMethods()) {
                        String methodName = m.getName();
                        if (!methodName.startsWith("add") || (m.getModifiers() & 1) == 0 || m.getParameterTypes().length != 1) continue;
                        String propertyName = Introspector.decapitalize(methodName.substring(3));
                        addMethods.put(propertyName, m);
                    }
                    holder.setValue(addMethods);
                }
            }
        }
        return (Method)addMethods.get(name);
    }

    private Object convertValueTo(Object value, Class targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException("target class is null");
        }
        if (value == null) {
            return null;
        }
        if (targetClass.equals(Object.class)) {
            return value;
        }
        AbstractSet convertedValue = null;
        if (targetClass.isAssignableFrom(value.getClass())) {
            convertedValue = value;
        } else if (value instanceof String && Enum.class.isAssignableFrom(targetClass)) {
            convertedValue = Enum.valueOf(targetClass, (String)value);
        } else {
            TypeConverter typeConverter = null;
            if (this.typeConvertersByClass != null) {
                typeConverter = this.typeConvertersByClass.get(targetClass);
            }
            if (typeConverter != null) {
                convertedValue = typeConverter.fromJSON(value);
            } else if (List.class.isInstance(value)) {
                List list = (List)value;
                if (targetClass.isArray()) {
                    convertedValue = Array.newInstance(targetClass.getComponentType(), list.size());
                    int idx = 0;
                    for (Object o : list) {
                        Array.set(convertedValue, idx++, o);
                    }
                } else if (targetClass.isAssignableFrom(HashSet.class)) {
                    convertedValue = new HashSet(list);
                } else if (targetClass.isAssignableFrom(LinkedHashSet.class)) {
                    convertedValue = new LinkedHashSet(list);
                } else if (targetClass.isAssignableFrom(TreeSet.class)) {
                    convertedValue = new TreeSet(list);
                }
            }
            if (convertedValue == null) {
                convertedValue = ConvertUtils.convert((String)value.toString(), (Class)targetClass);
            }
        }
        return convertedValue;
    }

    private Object createNewTargetInstance(Class typeHint, boolean object) {
        Class replacement;
        if (typeHint == null || typeHint.equals(Object.class)) {
            typeHint = object ? Map.class : List.class;
            if (log.isDebugEnabled()) {
                log.debug("replace null typeHint with " + typeHint);
            }
        }
        if (typeHint.isInterface() && (replacement = this.getReplacementForKnownInterface(typeHint)) != null) {
            typeHint = replacement;
            if (log.isDebugEnabled()) {
                log.debug("interface replaced with " + typeHint);
            }
        }
        try {
            for (ObjectFactory factory : this.objectFactories) {
                if (!factory.supports(typeHint)) continue;
                return factory.create(typeHint);
            }
            if (typeHint.isArray()) {
                return new ArrayList();
            }
            return typeHint.newInstance();
        }
        catch (InstantiationException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
    }

    private Class getTypeHint(ParseContext cx, String parsePathInfo, JSONTokenizer tokenizer, String name, boolean isProperty, boolean primitive) {
        Class cls;
        Class typeOfProperty;
        Class memberType = cx.getMemberType();
        if (memberType == null && isProperty && (typeOfProperty = this.getTypeOfProperty(cx, name)) != null) {
            memberType = typeOfProperty;
        }
        if (log.isDebugEnabled()) {
            log.debug("typeHint = " + memberType + ", name = " + name);
        }
        if ((cls = this.getTypeHint(parsePathInfo, tokenizer, memberType, !primitive)) != null) {
            memberType = cls;
            if (log.isDebugEnabled()) {
                log.debug("set typeHint to  " + memberType);
            }
        }
        return memberType;
    }

    private Class getTypeOfProperty(ParseContext cx, String name) {
        Class<?> result = null;
        Object target = cx.target;
        try {
            Method m;
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)target, (String)name);
            if (pd != null && (m = pd.getWriteMethod()) != null) {
                result = m.getParameterTypes()[0];
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionWrapper.wrap(e);
        }
        return result;
    }

    private Class getTypeHint(String parsePathInfo, JSONTokenizer tokenizer, Class typeHint, boolean consultTypeMapper) {
        Class typeHintFromTypeMapper;
        for (Map.Entry<PathMatcher, Class> e : this.typeHints.entrySet()) {
            PathMatcher matcher = e.getKey();
            if (!matcher.matches(parsePathInfo, Object.class)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Parse path '" + parsePathInfo + "' matches " + matcher + ": setting type hint to " + typeHint);
            }
            typeHint = e.getValue();
            break;
        }
        if (this.typeMapper != null && consultTypeMapper && (typeHintFromTypeMapper = this.typeMapper.getTypeHint(tokenizer, parsePathInfo, typeHint)) != null) {
            typeHint = typeHintFromTypeMapper;
        }
        return typeHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getTypeHintFromAnnotation(ParseContext cx, String name) {
        HashMap typeHintsFromAnnotation;
        ValueHolder holder;
        Class<?> cls = cx.target.getClass();
        ValueHolder existing = classToTypeHintFromAnnotation.putIfAbsent(cls, holder = new ValueHolder());
        if (existing != null) {
            holder = existing;
        }
        if ((typeHintsFromAnnotation = (HashMap)holder.getValue()) == null) {
            ValueHolder valueHolder = holder;
            synchronized (valueHolder) {
                typeHintsFromAnnotation = (Map)holder.getValue();
                if (typeHintsFromAnnotation == null) {
                    typeHintsFromAnnotation = new HashMap();
                    for (Method m : cls.getMethods()) {
                        Class<?>[] parameterTypes;
                        String propertyName = this.getPropertyNameFromMethod(m);
                        if (propertyName == null) continue;
                        JSONTypeHint typeHintAnnotation = m.getAnnotation(JSONTypeHint.class);
                        if (typeHintAnnotation != null) {
                            typeHintsFromAnnotation.put(propertyName, typeHintAnnotation.value());
                        }
                        if ((parameterTypes = m.getParameterTypes()).length != 1 || !parameterTypes[0].isArray()) continue;
                        typeHintsFromAnnotation.put(propertyName, parameterTypes[0].getComponentType());
                    }
                    holder.setValue(typeHintsFromAnnotation);
                }
            }
        }
        return (Class)typeHintsFromAnnotation.get(name);
    }

    private String getPropertyNameFromMethod(Method m) {
        String methodName = m.getName();
        boolean isIsser = methodName.startsWith("is");
        boolean isGetter = isIsser || methodName.startsWith("get");
        boolean isSetter = methodName.startsWith("set");
        if (isGetter || isSetter) {
            return Introspector.decapitalize(methodName.substring(isIsser ? 2 : 3));
        }
        return null;
    }

    public static String getPropertyNameFromAnnotation(Object target, String value) {
        for (PropertyDescriptor pd : PropertyUtils.getPropertyDescriptors(target.getClass())) {
            String jsonPropertyName = JSONParser.getJSONPropertyNameFromDescriptor(target, pd);
            if (!jsonPropertyName.equals(value)) continue;
            return pd.getName();
        }
        return null;
    }

    public static String getJSONPropertyNameFromDescriptor(Object bean, PropertyDescriptor pd) {
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        JSONProperty jsonProperty = null;
        if (readMethod != null) {
            jsonProperty = readMethod.getAnnotation(JSONProperty.class);
        }
        if (jsonProperty == null && writeMethod != null) {
            jsonProperty = writeMethod.getAnnotation(JSONProperty.class);
        }
        if (jsonProperty != null && !jsonProperty.value().equals("")) {
            return jsonProperty.value();
        }
        return pd.getName();
    }

    private class ParseContext {
        private Object target;
        private ParseContext parent;
        private Class memberType;
        private String info = "";

        public ParseContext(Object target, Class memberType) {
            this(target, memberType, null);
        }

        private ParseContext(Object target, Class memberType, ParseContext parent) {
            this.target = target;
            this.parent = parent;
            this.memberType = memberType;
        }

        public Class getMemberType() {
            return this.memberType;
        }

        public ParseContext push(Object target, Class memberType, String info) {
            ParseContext child = new ParseContext(target, memberType, this);
            child.info = this.info + info;
            return child;
        }

        public ParseContext pop() {
            return this.parent;
        }

        public String getParsePathInfo(String name) {
            String parsePathInfo = name.equals("[]") ? this.info + name : this.info + "." + name;
            return parsePathInfo;
        }

        public String toString() {
            return super.toString() + ", target = " + this.target + ", memberType = " + this.memberType + ", info = " + this.info;
        }
    }
}

