/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.tokenize;

import java.util.Arrays;
import org.svenson.JSONParseException;
import org.svenson.tokenize.TokenType;
import org.svenson.util.Util;

public class Token {
    private Object value;
    private TokenType type;
    private static final Token[] SINGLETON_TOKENS = new Token[TokenType.values().length];

    public static Token getToken(TokenType type) {
        return Token.getToken(type, null);
    }

    public static Token getToken(TokenType type, Object value) {
        if (type.isClassRestricted()) {
            return new Token(type, value);
        }
        return SINGLETON_TOKENS[type.ordinal()];
    }

    private Token(TokenType type, Object value) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type must be given");
        }
        this.type = type;
        this.value = value;
    }

    public final Object value() {
        return this.value;
    }

    public final TokenType type() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Token) {
            Token that = (Token)obj;
            return this.type == that.type && Util.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        return 37 + 17 * this.type.hashCode() + 17 * Util.safeHashcode(this.value);
    }

    public boolean isType(TokenType type) {
        return this.type == type;
    }

    public void expect(TokenType ... types) {
        for (TokenType type : types) {
            if (this.type() != type) continue;
            return;
        }
        throw new JSONParseException("Token " + this + " is not of one of the expected types " + Arrays.asList(types));
    }

    public String toString() {
        return super.toString() + ": " + (Object)((Object)this.type) + " " + this.value;
    }

    static {
        for (TokenType type : TokenType.values()) {
            if (type.isClassRestricted()) continue;
            Token.SINGLETON_TOKENS[type.ordinal()] = new Token(type, type.getValidContent());
        }
    }
}

