/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.svenson.DynamicProperties;
import org.svenson.JSONParser;
import org.svenson.util.ExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONBeanUtil {
    public static Set<String> getAllPropertyNames(Object bean) {
        HashSet<String> names = new HashSet<String>();
        if (bean instanceof DynamicProperties) {
            names.addAll(((DynamicProperties)bean).propertyNames());
        }
        if (bean instanceof Map) {
            names.addAll(((Map)bean).keySet());
        }
        names.addAll(JSONBeanUtil.getBeanPropertyNames(bean));
        return names;
    }

    public static Set<String> getBeanPropertyNames(Object bean) {
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors(bean.getClass());
        HashSet<String> names = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Method readMethod = pd.getReadMethod();
            Method writeMethod = pd.getWriteMethod();
            if (readMethod == null || writeMethod == null) continue;
            String name = JSONParser.getJSONPropertyNameFromDescriptor(bean, pd);
            names.add(name);
        }
        return names;
    }

    public static Object getProperty(Object bean, String name) throws IllegalArgumentException {
        try {
            String propertyName = JSONParser.getPropertyNameFromAnnotation(bean, name);
            if (propertyName != null && PropertyUtils.isReadable((Object)bean, (String)propertyName)) {
                return PropertyUtils.getProperty((Object)bean, (String)propertyName);
            }
            if (bean instanceof DynamicProperties) {
                return ((DynamicProperties)bean).getProperty(name);
            }
            if (bean instanceof Map) {
                return ((Map)bean).get(name);
            }
            throw new IllegalArgumentException(bean + " has no JSON property with the name '" + name + "' and does not implements DynamicProperties");
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionWrapper.wrap(e);
        }
    }

    public static void setProperty(Object bean, String name, Object value) throws IllegalArgumentException {
        block7: {
            try {
                String propertyName = JSONParser.getPropertyNameFromAnnotation(bean, name);
                if (propertyName != null && PropertyUtils.isWriteable((Object)bean, (String)propertyName)) {
                    PropertyUtils.setProperty((Object)bean, (String)propertyName, (Object)value);
                    break block7;
                }
                if (bean instanceof DynamicProperties) {
                    ((DynamicProperties)bean).setProperty(name, value);
                    break block7;
                }
                if (bean instanceof Map) {
                    ((Map)bean).put(name, value);
                    break block7;
                }
                throw new IllegalArgumentException(bean + " has no JSON property with the name '" + name + "' and does not implements DynamicProperties");
            }
            catch (IllegalAccessException e) {
                throw ExceptionWrapper.wrap(e);
            }
            catch (InvocationTargetException e) {
                throw ExceptionWrapper.wrap(e);
            }
            catch (NoSuchMethodException e) {
                throw ExceptionWrapper.wrap(e);
            }
        }
    }
}

