/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.svenson.converter.JSONConverter;
import org.svenson.converter.TypeConverter;
import org.svenson.converter.TypeConverterRepository;
import org.svenson.util.ValueHolder;

public class TypeConverterCache {
    private ConcurrentMap<Class, ValueHolder<Map<String, TypeConverter>>> classToTypeConverter = new ConcurrentHashMap<Class, ValueHolder<Map<String, TypeConverter>>>();
    private TypeConverterRepository typeConverterRepository;

    public TypeConverterCache(TypeConverterRepository typeConverterRepository) {
        this.typeConverterRepository = typeConverterRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeConverter getTypeConverter(Object target, String name) {
        HashMap<String, TypeConverter> typeConverters;
        ValueHolder holder = new ValueHolder();
        Class<?> cls = target.getClass();
        ValueHolder existing = this.classToTypeConverter.putIfAbsent(cls, holder);
        if (existing != null) {
            holder = existing;
        }
        if ((typeConverters = (HashMap<String, TypeConverter>)holder.getValue()) == null) {
            ValueHolder valueHolder = holder;
            synchronized (valueHolder) {
                typeConverters = (Map)holder.getValue();
                if (typeConverters == null) {
                    typeConverters = new HashMap<String, TypeConverter>();
                    for (PropertyDescriptor pd : PropertyUtils.getPropertyDescriptors(cls)) {
                        Method readMethod = pd.getReadMethod();
                        Method writeMethod = pd.getWriteMethod();
                        JSONConverter anno = readMethod.getAnnotation(JSONConverter.class);
                        if (anno == null && writeMethod != null) {
                            anno = writeMethod.getAnnotation(JSONConverter.class);
                        }
                        if (anno == null) continue;
                        TypeConverter typeConverter = null;
                        typeConverter = anno.name().length() == 0 ? this.typeConverterRepository.getConverterByType(anno.type()) : this.typeConverterRepository.getConverterById(anno.name());
                        typeConverters.put(pd.getName(), typeConverter);
                    }
                    holder.setValue(typeConverters);
                }
            }
        }
        return (TypeConverter)typeConverters.get(name);
    }
}

