/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.concurrency;

import com.google.code.tempusfugit.concurrency.annotations.Repeating;
import junit.framework.AssertionFailedError;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

class RunRepeatedly
extends Statement {
    private final FrameworkMethod method;
    private final Statement statement;

    RunRepeatedly(FrameworkMethod method, Statement statement) {
        this.method = method;
        this.statement = statement;
    }

    public void evaluate() throws Throwable {
        if (RunRepeatedly.repeating(this.method)) {
            for (int i = 0; i < RunRepeatedly.repetition(this.method); ++i) {
                try {
                    this.statement.evaluate();
                    continue;
                }
                catch (AssertionFailedError e) {
                    throw new AssertionFailedError(String.format("%s (failed after %d successful attempts)", e.getMessage(), i));
                }
            }
        } else {
            this.statement.evaluate();
        }
    }

    private static boolean repeating(FrameworkMethod method) {
        return method.getAnnotation(Repeating.class) != null;
    }

    private static int repetition(FrameworkMethod method) {
        return ((Repeating)method.getAnnotation(Repeating.class)).repetition();
    }
}

