/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.concurrency;

import com.google.code.tempusfugit.concurrency.Interruptible;
import com.google.code.tempusfugit.temporal.Duration;

public final class ThreadUtils {
    public static void sleep(Duration duration) {
        ThreadUtils.resetInterruptFlagWhen(ThreadUtils.sleepingIsInterrupted(duration));
    }

    private static Interruptible<Void> sleepingIsInterrupted(final Duration duration) {
        return new Interruptible<Void>(){

            @Override
            public Void call() throws InterruptedException {
                Thread.sleep(duration.inMillis());
                return null;
            }
        };
    }

    public static <T> T resetInterruptFlagWhen(Interruptible<T> interruptible) {
        try {
            return interruptible.call();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

