/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.temporal;

import com.google.code.tempusfugit.temporal.Clock;
import com.google.code.tempusfugit.temporal.Duration;
import java.util.Date;

public final class MovableClock
implements Clock {
    private final Date now;

    public MovableClock() {
        this.now = new Date(0L);
    }

    public MovableClock(Date date) {
        this.now = new Date(date.getTime());
    }

    @Override
    public Date create() {
        return new Date(this.now.getTime());
    }

    public void setTime(Duration time) {
        this.now.setTime(time.inMillis());
    }

    public void incrementBy(Duration time) {
        this.now.setTime(this.now.getTime() + time.inMillis());
    }
}

