/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.temporal;

import com.google.code.tempusfugit.temporal.Duration;
import com.google.code.tempusfugit.temporal.RealClock;
import com.google.code.tempusfugit.temporal.StopWatch;

public final class Timeout {
    private Duration duration;
    private StopWatch stopWatch;

    public static Timeout timeout(Duration duration) {
        return new Timeout(duration);
    }

    public static Timeout timeout(Duration duration, StopWatch stopWatch) {
        return new Timeout(duration, stopWatch);
    }

    private Timeout(Duration duration) {
        this(duration, Timeout.startStopWatch());
    }

    private Timeout(Duration duration, StopWatch stopWatch) {
        if (duration.inMillis() <= 0L) {
            throw new IllegalArgumentException();
        }
        this.duration = duration;
        this.stopWatch = stopWatch;
    }

    public boolean hasExpired() {
        return this.stopWatch.markAndGetTotalElapsedTime().greaterThan(this.duration);
    }

    private static StopWatch startStopWatch() {
        return StopWatch.start(RealClock.now());
    }
}

