/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.temporal;

import com.google.code.tempusfugit.temporal.Condition;
import com.google.code.tempusfugit.temporal.Duration;
import com.google.code.tempusfugit.temporal.Sleeper;
import com.google.code.tempusfugit.temporal.StopWatch;
import com.google.code.tempusfugit.temporal.ThreadSleep;
import com.google.code.tempusfugit.temporal.Timeout;
import java.util.concurrent.TimeoutException;

public final class WaitFor {
    public static final Duration SLEEP_PERIOD = Duration.millis(50L);

    private WaitFor() {
    }

    public static void waitOrTimeout(Condition condition, Timeout timeout) throws InterruptedException, TimeoutException {
        WaitFor.waitOrTimeout(condition, timeout, new ThreadSleep(SLEEP_PERIOD));
    }

    public static void waitOrTimeout(Condition condition, Timeout timeout, Sleeper sleeper) throws TimeoutException, InterruptedException {
        if (WaitFor.success(condition, timeout, sleeper)) {
            return;
        }
        throw new TimeoutException();
    }

    @Deprecated
    public static void waitOrTimeout(Condition condition, Duration duration) throws TimeoutException, InterruptedException {
        WaitFor.waitOrTimeout(condition, Timeout.timeout(duration));
    }

    @Deprecated
    public static void waitOrTimeout(Condition condition, Duration duration, StopWatch stopWatch) throws TimeoutException, InterruptedException {
        WaitFor.waitOrTimeout(condition, Timeout.timeout(duration, stopWatch));
    }

    public static void waitUntil(Timeout timeout) throws InterruptedException {
        while (!timeout.hasExpired()) {
            Thread.sleep(SLEEP_PERIOD.inMillis());
        }
    }

    private static boolean success(Condition condition, Timeout timeout, Sleeper sleeper) throws InterruptedException {
        while (!timeout.hasExpired()) {
            if (condition.isSatisfied()) {
                return true;
            }
            sleeper.sleep();
        }
        return false;
    }
}

