/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.EndpointsFlag;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class ObjectMapperUtil {
    public static ObjectMapper createStandardObjectMapper() {
        return ObjectMapperUtil.createStandardObjectMapper(null);
    }

    public static ObjectMapper createStandardObjectMapper(ApiSerializationConfig config) {
        ObjectMapper objectMapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setBase64Variant(Base64Variants.MODIFIED_FOR_URL).setSerializerFactory(BeanSerializerFactory.instance.withSerializerModifier((BeanSerializerModifier)new DeepEmptyCheckingModifier()));
        ApiAnnotationIntrospector pair = EndpointsFlag.JSON_USE_JACKSON_ANNOTATIONS.isEnabled() ? AnnotationIntrospector.pair((AnnotationIntrospector)new ApiAnnotationIntrospector(config), (AnnotationIntrospector)new JacksonAnnotationIntrospector()) : new ApiAnnotationIntrospector(config);
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        return objectMapper;
    }

    private static boolean isEmpty(Object value) {
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                Object element = Array.get(value, i);
                if (element == null || ObjectMapperUtil.isEmpty(element)) continue;
                return false;
            }
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection c = (Collection)value;
            for (Object element : c) {
                if (element == null || ObjectMapperUtil.isEmpty(element)) continue;
                return false;
            }
            return true;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Map m = (Map)value;
            for (Object entryValue : m.values()) {
                if (entryValue == null || ObjectMapperUtil.isEmpty(entryValue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class DeepEmptyCheckingSerializer<T>
    extends JsonSerializer<T>
    implements ContextualSerializer {
        private final JsonSerializer<T> delegate;

        DeepEmptyCheckingSerializer(JsonSerializer<T> delegate) {
            this.delegate = delegate;
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            this.delegate.serialize(value, gen, serializers);
        }

        public boolean isEmpty(SerializerProvider provider, Object value) {
            return ObjectMapperUtil.isEmpty(value);
        }

        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            if (this.delegate instanceof ContextualSerializer) {
                return new DeepEmptyCheckingSerializer<T>(((ContextualSerializer)this.delegate).createContextual(provider, property));
            }
            return this;
        }
    }

    private static class DeepEmptyCheckingModifier
    extends BeanSerializerModifier {
        private DeepEmptyCheckingModifier() {
        }

        public JsonSerializer<?> modifyArraySerializer(SerializationConfig config, ArrayType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            return new DeepEmptyCheckingSerializer(serializer);
        }

        public JsonSerializer<?> modifyCollectionSerializer(SerializationConfig config, CollectionType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            return new DeepEmptyCheckingSerializer(serializer);
        }

        public JsonSerializer<?> modifyMapSerializer(SerializationConfig config, MapType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            if (serializer instanceof MapSerializer) {
                return new DeepEmptyCheckingSerializer(serializer);
            }
            return serializer;
        }
    }
}

