/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.AutoValue_Schema;
import com.google.api.server.spi.config.model.AutoValue_Schema_Field;
import com.google.api.server.spi.config.model.AutoValue_Schema_SchemaReference;
import com.google.api.server.spi.config.model.FieldType;
import com.google.api.server.spi.config.model.SchemaRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.reflect.TypeToken;
import javax.annotation.Nullable;

public abstract class Schema {
    public abstract String name();

    public abstract String type();

    @Nullable
    public abstract String description();

    public abstract ImmutableSortedMap<String, Field> fields();

    @Nullable
    public abstract Field mapValueSchema();

    @Nullable
    public abstract ImmutableList<String> enumValues();

    @Nullable
    public abstract ImmutableList<String> enumDescriptions();

    public static Builder builder() {
        return new AutoValue_Schema.Builder();
    }

    public static abstract class SchemaReference {
        public abstract SchemaRepository repository();

        public abstract ApiConfig apiConfig();

        public abstract TypeToken<?> type();

        public Schema get() {
            return this.repository().get(this.type(), this.apiConfig());
        }

        public static SchemaReference create(SchemaRepository repository, ApiConfig apiConfig, TypeToken type) {
            return new AutoValue_Schema_SchemaReference(repository, apiConfig, type);
        }
    }

    public static abstract class Field {
        public abstract String name();

        public abstract FieldType type();

        @Nullable
        public abstract String description();

        @Nullable
        public abstract SchemaReference schemaReference();

        @Nullable
        public abstract Field arrayItemSchema();

        public static Builder builder() {
            return new AutoValue_Schema_Field.Builder();
        }

        public static abstract class Builder {
            public abstract Builder setName(String var1);

            public abstract Builder setType(FieldType var1);

            public abstract Builder setDescription(String var1);

            public abstract Builder setSchemaReference(SchemaReference var1);

            public abstract Builder setArrayItemSchema(Field var1);

            public abstract Field build();
        }
    }

    public static abstract class Builder {
        private final ImmutableSortedMap.Builder<String, Field> fieldsBuilder = ImmutableSortedMap.naturalOrder();

        public abstract Builder setName(String var1);

        public abstract Builder setType(String var1);

        public abstract Builder setDescription(String var1);

        public abstract Builder setFields(ImmutableSortedMap<String, Field> var1);

        public abstract Builder setMapValueSchema(Field var1);

        public Builder addField(String name, Field field) {
            this.fieldsBuilder.put((Object)name, (Object)field);
            return this;
        }

        abstract ImmutableList.Builder<String> enumValuesBuilder();

        public Builder addEnumValue(String value) {
            this.enumValuesBuilder().add((Object)value);
            return this;
        }

        abstract ImmutableList.Builder<String> enumDescriptionsBuilder();

        public Builder addEnumDescription(String value) {
            this.enumDescriptionsBuilder().add((Object)value);
            return this;
        }

        abstract Schema autoBuild();

        public Schema build() {
            return this.setFields((ImmutableSortedMap<String, Field>)this.fieldsBuilder.build()).autoBuild();
        }
    }
}

