/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.client.util.Maps;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.Description;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.jsonwriter.JacksonResourceSchemaProvider;
import com.google.api.server.spi.config.jsonwriter.ResourceSchemaProvider;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.EndpointsFlag;
import com.google.api.server.spi.config.model.FieldType;
import com.google.api.server.spi.config.model.Schema;
import com.google.api.server.spi.config.model.Types;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class SchemaRepository {
    private static final Schema PLACEHOLDER_SCHEMA = Schema.builder().setName("_placeholder_").setType("_placeholder_").build();
    @VisibleForTesting
    static final Schema ANY_SCHEMA = Schema.builder().setName("_any").setType("any").build();
    @VisibleForTesting
    static final Schema MAP_SCHEMA = Schema.builder().setName("JsonMap").setType("object").build();
    private static final EnumSet<FieldType> SUPPORTED_MAP_KEY_TYPES = EnumSet.of(FieldType.STRING, new FieldType[]{FieldType.ENUM, FieldType.BOOLEAN, FieldType.INT8, FieldType.INT16, FieldType.INT32, FieldType.INT64, FieldType.FLOAT, FieldType.DOUBLE, FieldType.DATE, FieldType.DATE_TIME});
    @VisibleForTesting
    static final String ARRAY_UNUSED_MSG = "unused for array items";
    @VisibleForTesting
    static final String MAP_UNUSED_MSG = "unused for map values";
    private final Multimap<ApiKey, Schema> schemaByApiKeys = LinkedHashMultimap.create();
    private final Map<ApiSerializationConfig, Map<TypeToken<?>, Schema>> types = Maps.newLinkedHashMap();
    private final ResourceSchemaProvider resourceSchemaProvider = new JacksonResourceSchemaProvider();
    private final TypeLoader typeLoader;

    public SchemaRepository(TypeLoader typeLoader) {
        this.typeLoader = typeLoader;
    }

    public Schema get(TypeToken<?> type, ApiConfig config) {
        Map<TypeToken<?>, Schema> typesForConfig = this.getAllTypesForConfig(config);
        Schema schema = typesForConfig.get(type = ApiAnnotationIntrospector.getSchemaType(type, config));
        if (schema != null) {
            if (schema == PLACEHOLDER_SCHEMA) {
                throw new IllegalStateException("schema repository is in a bad state!");
            }
            return schema;
        }
        return null;
    }

    public Schema getOrAdd(TypeToken<?> type, ApiConfig config) {
        Map<TypeToken<?>, Schema> typesForConfig = this.getAllTypesForConfig(config);
        Schema schema = this.getOrCreateTypeForConfig(type, typesForConfig, config);
        if (schema == PLACEHOLDER_SCHEMA) {
            throw new IllegalStateException("schema repository is in a bad state!");
        }
        return schema;
    }

    public ImmutableList<Schema> getAllSchemaForApi(ApiKey apiKey) {
        return ImmutableList.copyOf((Collection)this.schemaByApiKeys.get((Object)apiKey.withoutRoot()));
    }

    private Map<TypeToken<?>, Schema> getAllTypesForConfig(ApiConfig config) {
        LinkedHashMap typesForConfig = this.types.get(config.getSerializationConfig());
        if (typesForConfig == null) {
            typesForConfig = Maps.newLinkedHashMap();
            this.types.put(config.getSerializationConfig(), typesForConfig);
        }
        return typesForConfig;
    }

    private Schema getOrCreateTypeForConfig(TypeToken type, Map<TypeToken<?>, Schema> typesForConfig, ApiConfig config) {
        type = ApiAnnotationIntrospector.getSchemaType(type, config);
        Schema schema = typesForConfig.get(type);
        ApiKey key = config.getApiKey().withoutRoot();
        if (schema != null) {
            if (schema != PLACEHOLDER_SCHEMA) {
                this.addSchemaToApi(key, schema);
            }
            return schema;
        }
        typesForConfig.put(type, PLACEHOLDER_SCHEMA);
        TypeToken<?> arrayItemType = Types.getArrayItemType(type);
        if (this.typeLoader.isSchemaType(type)) {
            throw new IllegalArgumentException("Can't add a primitive type as a resource");
        }
        if (arrayItemType != null) {
            Schema.Field.Builder arrayItemSchema = Schema.Field.builder().setName(ARRAY_UNUSED_MSG);
            this.fillInFieldInformation(arrayItemSchema, arrayItemType, null, typesForConfig, config);
            schema = Schema.builder().setName(Types.getSimpleName(type, config.getSerializationConfig())).setType("object").addField("items", Schema.Field.builder().setName("items").setType(FieldType.ARRAY).setArrayItemSchema(arrayItemSchema.build()).build()).build();
            typesForConfig.put(type, schema);
            this.schemaByApiKeys.put((Object)key, (Object)schema);
            return schema;
        }
        if (Types.isObject(type)) {
            typesForConfig.put(type, ANY_SCHEMA);
            this.schemaByApiKeys.put((Object)key, (Object)ANY_SCHEMA);
            return ANY_SCHEMA;
        }
        if (Types.isMapType(type)) {
            schema = MAP_SCHEMA;
            TypeToken mapSupertype = type.getSupertype(Map.class);
            boolean hasConcreteKeyValue = Types.isConcreteType(mapSupertype.getType());
            boolean forceJsonMapSchema = EndpointsFlag.MAP_SCHEMA_FORCE_JSON_MAP_SCHEMA.isEnabled();
            if (hasConcreteKeyValue && !forceJsonMapSchema) {
                schema = (Schema)this.createMapSchema(mapSupertype, typesForConfig, config).or((Object)schema);
            }
            typesForConfig.put(type, schema);
            this.schemaByApiKeys.put((Object)key, (Object)schema);
            return schema;
        }
        if (Types.isEnumType(type)) {
            Schema.Builder builder = Schema.builder().setName(Types.getSimpleName(type, config.getSerializationConfig())).setType("string");
            for (Field field : type.getRawType().getFields()) {
                if (!field.isEnumConstant()) continue;
                builder.addEnumValue(field.getName());
                Description description = field.getAnnotation(Description.class);
                builder.addEnumDescription(description == null ? "" : description.value());
            }
            schema = builder.build();
            typesForConfig.put(type, schema);
            this.schemaByApiKeys.put((Object)key, (Object)schema);
            return schema;
        }
        schema = this.createBeanSchema(type, typesForConfig, config);
        typesForConfig.put(type, schema);
        this.schemaByApiKeys.put((Object)key, (Object)schema);
        return schema;
    }

    private void addSchemaToApi(ApiKey key, Schema schema) {
        if (this.schemaByApiKeys.containsEntry((Object)key, (Object)schema)) {
            return;
        }
        this.schemaByApiKeys.put((Object)key, (Object)schema);
        for (Schema.Field f : schema.fields().values()) {
            while (f.type() == FieldType.ARRAY) {
                f = f.arrayItemSchema();
            }
            if (f.type() != FieldType.OBJECT && f.type() != FieldType.ENUM) continue;
            this.addSchemaToApi(key, f.schemaReference().get());
        }
        Schema.Field mapValueSchema = schema.mapValueSchema();
        if (mapValueSchema != null && mapValueSchema.schemaReference() != null) {
            this.addSchemaToApi(key, mapValueSchema.schemaReference().get());
        }
    }

    private Optional<Schema> createMapSchema(TypeToken<Map<?, ?>> mapType, Map<TypeToken<?>, Schema> typesForConfig, ApiConfig config) {
        boolean supportedValueType;
        FieldType keyFieldType = FieldType.fromType(Types.getTypeParameter(mapType, 0));
        boolean supportedKeyType = SUPPORTED_MAP_KEY_TYPES.contains((Object)keyFieldType);
        if (!supportedKeyType) {
            String message = "Map field type '" + mapType + "' has a key type not serializable to String";
            if (EndpointsFlag.MAP_SCHEMA_IGNORE_UNSUPPORTED_KEY_TYPES.isEnabled()) {
                System.err.println(message + ", its schema will be JsonMap");
            } else {
                throw new IllegalArgumentException(message);
            }
        }
        TypeToken<?> valueTypeToken = Types.getTypeParameter(mapType, 1);
        FieldType valueFieldType = FieldType.fromType(valueTypeToken);
        boolean supportArrayValues = EndpointsFlag.MAP_SCHEMA_SUPPORT_ARRAYS_VALUES.isEnabled();
        boolean bl = supportedValueType = supportArrayValues || valueFieldType != FieldType.ARRAY;
        if (!supportedValueType) {
            System.err.println("Map field type '" + mapType + "' has an array-like value type, its schema will be JsonMap");
        }
        if (!supportedKeyType || !supportedValueType) {
            return Optional.absent();
        }
        TypeToken<?> valueSchemaType = ApiAnnotationIntrospector.getSchemaType(valueTypeToken, config);
        Schema.Builder builder = Schema.builder().setName(Types.getSimpleName(mapType, config.getSerializationConfig())).setType("object");
        Schema.Field.Builder fieldBuilder = Schema.Field.builder().setName(MAP_UNUSED_MSG);
        this.fillInFieldInformation(fieldBuilder, valueSchemaType, null, typesForConfig, config);
        return Optional.of((Object)builder.setMapValueSchema(fieldBuilder.build()).build());
    }

    private Schema createBeanSchema(TypeToken<?> type, Map<TypeToken<?>, Schema> typesForConfig, ApiConfig config) {
        Schema.Builder builder = Schema.builder().setName(Types.getSimpleName(type, config.getSerializationConfig())).setType("object");
        ResourceSchema schema = this.resourceSchemaProvider.getResourceSchema(type, config);
        for (Map.Entry<String, ResourcePropertySchema> entry : schema.getProperties().entrySet()) {
            String propertyName = entry.getKey();
            ResourcePropertySchema propertySchema = entry.getValue();
            TypeToken<?> propertyType = propertySchema.getType();
            if (propertyType == null) continue;
            Schema.Field.Builder fieldBuilder = Schema.Field.builder().setName(propertyName);
            this.fillInFieldInformation(fieldBuilder, propertyType, propertySchema.getDescription(), typesForConfig, config);
            builder.addField(propertyName, fieldBuilder.build());
        }
        return builder.build();
    }

    private void fillInFieldInformation(Schema.Field.Builder builder, TypeToken<?> fieldType, String description, Map<TypeToken<?>, Schema> typesForConfig, ApiConfig config) {
        FieldType ft = FieldType.fromType(fieldType);
        builder.setType(ft);
        builder.setDescription(description);
        if (ft == FieldType.OBJECT || ft == FieldType.ENUM) {
            this.getOrCreateTypeForConfig(fieldType, typesForConfig, config);
            builder.setSchemaReference(Schema.SchemaReference.create(this, config, fieldType));
        } else if (ft == FieldType.ARRAY) {
            Schema.Field.Builder arrayItemBuilder = Schema.Field.builder().setName(ARRAY_UNUSED_MSG);
            this.fillInFieldInformation(arrayItemBuilder, ApiAnnotationIntrospector.getSchemaType(Types.getArrayItemType(fieldType), config), null, typesForConfig, config);
            builder.setArrayItemSchema(arrayItemBuilder.build());
        }
    }
}

